/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork;

import it.geosolutions.geonetwork.GNClient;
import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.GNPrivConfiguration;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.gcube.spatial.data.geonetwork.GeoNetworkPublisher;
import org.gcube.spatial.data.geonetwork.configuration.AuthorizationException;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;
import org.gcube.spatial.data.geonetwork.configuration.ConfigurationManager;
import org.geotoolkit.xml.XML;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.opengis.metadata.Metadata;

public class GeoNetwork
implements GeoNetworkPublisher {
    private static XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
    private Configuration config = ConfigurationManager.get();
    private GNClient theClient = null;

    public static GeoNetworkPublisher get() throws Exception {
        return new GeoNetwork();
    }

    private GeoNetwork() throws Exception {
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void login() throws AuthorizationException {
        GNClient client = this.getClient();
        if (!client.login(this.config.getGeoNetworkUser(), this.config.getGeoNetworkPassword())) {
            throw new AuthorizationException();
        }
    }

    @Override
    public GNSearchResponse query(GNSearchRequest request) throws GNLibException, GNServerException {
        return this.getClient().search(request);
    }

    @Override
    public GNSearchResponse query(File fileRequest) throws GNLibException, GNServerException {
        return this.getClient().search(fileRequest);
    }

    @Override
    public Metadata getById(long id) throws GNLibException, GNServerException, JAXBException {
        String xml = out.outputString(this.getClient().get(Long.valueOf(id)));
        return (Metadata)XML.unmarshal((String)xml);
    }

    @Override
    public Metadata getById(String UUID) throws GNLibException, GNServerException, JAXBException {
        return (Metadata)XML.unmarshal((String)this.getByIdAsRawString(UUID));
    }

    @Override
    public String getByIdAsRawString(String UUID) throws GNLibException, GNServerException, JAXBException {
        return out.outputString(this.getClient().get(UUID));
    }

    @Override
    public void setPrivileges(long metadataId, GNPrivConfiguration cfg) throws GNLibException, GNServerException, AuthorizationException {
        GNClient client = this.getClient();
        if (!client.login(this.config.getGeoNetworkUser(), this.config.getGeoNetworkPassword())) {
            throw new AuthorizationException();
        }
        client.setPrivileges(metadataId, cfg);
    }

    @Override
    public long insertMetadata(GNInsertConfiguration configuration, File metadataFile) throws GNLibException, GNServerException, AuthorizationException {
        GNClient client = this.getClient();
        if (!client.login(this.config.getGeoNetworkUser(), this.config.getGeoNetworkPassword())) {
            throw new AuthorizationException();
        }
        return client.insertMetadata(configuration, metadataFile);
    }

    @Override
    public long insertMetadata(GNInsertConfiguration configuration, Metadata meta) throws GNLibException, GNServerException, AuthorizationException, IOException, JAXBException {
        return this.insertMetadata(configuration, GeoNetwork.meta2File(meta));
    }

    @Override
    public long insertMetadata(File requestFile) throws GNLibException, GNServerException, AuthorizationException {
        GNClient client = this.getClient();
        if (!client.login(this.config.getGeoNetworkUser(), this.config.getGeoNetworkPassword())) {
            throw new AuthorizationException();
        }
        return client.insertRequest(requestFile);
    }

    @Override
    public long insertMetadata(Metadata meta) throws GNLibException, GNServerException, AuthorizationException, IOException, JAXBException {
        return this.insertMetadata(GeoNetwork.meta2File(meta));
    }

    @Override
    public void updateMetadata(long id, File metadataFile) throws GNLibException, GNServerException, AuthorizationException {
        GNClient client = this.getClient();
        if (!client.login(this.config.getGeoNetworkUser(), this.config.getGeoNetworkPassword())) {
            throw new AuthorizationException();
        }
        client.updateMetadata(id, metadataFile);
    }

    @Override
    public void updateMetadata(long id, Metadata meta) throws GNLibException, GNServerException, AuthorizationException, IOException, JAXBException {
        this.updateMetadata(id, GeoNetwork.meta2File(meta));
    }

    @Override
    public void deleteMetadata(long id) throws GNLibException, GNServerException, AuthorizationException {
        GNClient client = this.getClient();
        if (!client.login(this.config.getGeoNetworkUser(), this.config.getGeoNetworkPassword())) {
            throw new AuthorizationException();
        }
        client.deleteMetadata(id);
    }

    private synchronized GNClient getClient() {
        if (this.theClient == null) {
            this.theClient = new GNClient(this.config.getGeoNetworkEndpoint());
        }
        return this.theClient;
    }

    private static File meta2File(Metadata meta) throws IOException, JAXBException {
        File temp = File.createTempFile("meta", ".xml");
        FileWriter writer = new FileWriter(temp);
        writer.write(XML.marshal((Object)meta));
        writer.close();
        return temp;
    }
}

