/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.geonetwork.configuration;

import java.security.Key;
import java.util.List;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.utils.encryption.StringEncrypter;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;

public class DefaultConfiguration
implements Configuration {
    private String url;
    private String user;
    private String pwd;

    public DefaultConfiguration() throws Exception {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Gis'").addCondition("$resource/Profile/Platform/Name/text() eq 'geonetwork'").setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        List accesspoints = client.submit((Query)query);
        if (accesspoints.size() == 0) {
            throw new Exception("No Resource found under current scope " + ScopeProvider.instance.get());
        }
        for (ServiceEndpoint.AccessPoint point : accesspoints) {
            this.url = point.address();
            this.user = point.username();
            this.pwd = StringEncrypter.getEncrypter().decrypt(point.password(), new Key[0]);
        }
    }

    @Override
    public String getGeoNetworkEndpoint() {
        return this.url;
    }

    @Override
    public String getGeoNetworkUser() {
        return this.user;
    }

    @Override
    public String getGeoNetworkPassword() {
        return this.pwd;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DefaultConfiguration [url=");
        builder.append(this.url);
        builder.append(", user=");
        builder.append(this.user);
        builder.append(", pwd=");
        builder.append(this.pwd);
        builder.append("]");
        return builder.toString();
    }
}

