package org.gcube.spatial.data.geonetwork.configuration;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.util.List;

import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;



public class DefaultConfiguration implements Configuration {

//	private static  ISClient client;
	
	private String url;
	private String user;
	private String pwd;
	
	
//	public DefaultConfiguration() throws Exception {
//		client=GHNContext.getImplementation(ISClient.class);
//		GCUBERuntimeResourceQuery runtimeQuery=client.getQuery(GCUBERuntimeResourceQuery.class);
//		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Category", "Gis"));
//		runtimeQuery.addAtomicConditions(new AtomicCondition("//Profile/Platform/Name", "geonetwork"));
//		List<GCUBERuntimeResource> list=client.execute(runtimeQuery, GCUBEScope.getScope(ScopeProvider.instance.get()));
//		for(GCUBERuntimeResource rr:list){
//			try{
//				for(AccessPoint access:rr.getAccessPoints())
//					if(access.getEntryname().equals("geonetwork")){	
//						url=access.getEndpoint();
//						user=access.getUsername();
//						pwd=access.getPassword();
//					}
//			}catch(Exception e){e.printStackTrace();}
//		}
//	}
	
	public DefaultConfiguration() throws Exception {
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		 
		query.addCondition("$resource/Profile/Category/text() eq 'Gis'")
				.addCondition("$resource/Profile/Platform/Name/text() eq 'geonetwork'")
		         .setResult("$resource/Profile/AccessPoint");
		 
		DiscoveryClient<AccessPoint> client = clientFor(AccessPoint.class);
		 
		List<AccessPoint> accesspoints = client.submit(query);
		if(accesspoints.size()==0) throw new Exception("No Resource found under current scope "+ScopeProvider.instance.get()); 
		for (AccessPoint point : accesspoints) {
			url=point.address();
			user=point.username();
			pwd=point.password();
		}
	}
	
	@Override
	public String getGeoNetworkEndpoint() {
		return url;
	}

	@Override
	public String getGeoNetworkUser() {
		return user;
	}

	@Override
	public String getGeoNetworkPassword() {
		return pwd;
	}

}
