/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.connector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ServletRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String> headerMap = new HashMap<String, String>();
    private Map<String, String> paramsMap = new HashMap<String, String>();

    public ServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public void addHeader(String name, String value) {
        this.headerMap.put(name, new String(value));
    }

    public Enumeration<String> getHeaderNames() {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        ArrayList<String> list = new ArrayList<String>();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String header = ((String)e.nextElement()).toString();
            list.add(header);
        }
        Iterator<String> i = this.headerMap.keySet().iterator();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return Collections.enumeration(list);
    }

    public String getHeader(String name) {
        String value = this.headerMap.get("" + name);
        if (value != null) {
            return value.toString();
        }
        return ((HttpServletRequest)this.getRequest()).getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        Enumeration e = super.getHeaders(name);
        if (e != null && e.hasMoreElements()) {
            return e;
        }
        ArrayList<String> l = new ArrayList<String>();
        if (this.headerMap.get(name) != null) {
            l.add(this.headerMap.get(name));
        }
        return Collections.enumeration(l);
    }

    public void addParameter(String name, String value) {
        this.paramsMap.put(name, value);
    }

    public String getParameter(String name) {
        if (this.paramsMap.get(name) != null) {
            return this.paramsMap.get(name);
        }
        HttpServletRequest req = (HttpServletRequest)super.getRequest();
        return req.getParameter(name);
    }
}

