/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.connector;

import java.util.Base64;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.access.connector.rest.GCubeRestClient;
import org.gcube.data.access.connector.rest.entity.AccessibleCredentialsEntity;
import org.gcube.data.access.connector.utils.GCubeCache;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@XmlRootElement(name="authentication-filter")
public class GeoServerConnectorRequestHandler
extends RequestHandler {
    protected static final String REQUEST_HANDLER_NAME = "authentication-filter";
    private static final String GEOSERVER_CREDENTIALS = "/GeoServer/credentials/";
    private Logger logger;
    private GCubeCache<String, String> gCubeCache;
    private GCubeRestClient restClient = new GCubeRestClient();

    public GeoServerConnectorRequestHandler() {
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.gCubeCache = new GCubeCache(100L, 100L, 5);
    }

    public String getName() {
        return REQUEST_HANDLER_NAME;
    }

    public void handleRequest(RequestEvent e) {
        this.logger.warn("Handling request");
        HttpServletRequest httpServletRequest = e.request();
        String host = ((ApplicationContext)e.context()).container().configuration().hostname();
        String token = this.getToken(httpServletRequest);
        this.logger.warn("Retrieve token from request = " + token);
        if (StringUtils.hasText((String)token)) {
            this.logger.warn("Token found: " + token);
            if (this.validateToken(token)) {
                String endpoint = this.getEndpoint(token);
                this.logger.warn("Endpoint found: " + endpoint);
                if (StringUtils.hasText((String)endpoint)) {
                    String usernameCache = this.gCubeCache.get("username");
                    String passwordCache = this.gCubeCache.get("password");
                    String tokenCache = this.gCubeCache.get("token");
                    if (token.equals(tokenCache)) {
                        this.logger.warn("Set credentials attribute retrieved from cache " + usernameCache + " " + passwordCache);
                        httpServletRequest.setAttribute("username", (Object)usernameCache);
                        httpServletRequest.setAttribute("password", (Object)passwordCache);
                    } else {
                        String url = endpoint + GEOSERVER_CREDENTIALS + host + "?" + "gcube-token" + "=" + token;
                        AccessibleCredentialsEntity accessibleCredentials = this.restClient.getAccessibleCredentials(url);
                        this.logger.warn("Credentials: " + accessibleCredentials.getUsername() + "/" + accessibleCredentials.getPassword());
                        httpServletRequest.setAttribute("username", (Object)accessibleCredentials.getUsername());
                        httpServletRequest.setAttribute("password", (Object)accessibleCredentials.getPassword());
                        this.logger.warn("Put token in the cache: " + token);
                        this.gCubeCache.put("token", token);
                        this.logger.warn("Put also username and password in the cache");
                        this.gCubeCache.put("username", accessibleCredentials.getUsername());
                        this.gCubeCache.put("password", accessibleCredentials.getPassword());
                    }
                }
            } else {
                this.logger.error("Invalid token in the request");
                RequestError.request_not_authorized_error.fire("Invalid token in the request");
            }
        } else {
            this.logger.warn("Token not present in the request: NO/OP");
        }
    }

    public String toString() {
        return this.getName();
    }

    private String getToken(HttpServletRequest httpServletRequest) {
        String gCubeToken = httpServletRequest.getParameter("gcube-token");
        if (StringUtils.hasText((String)gCubeToken)) {
            this.logger.warn("Get token from query-string");
            return gCubeToken;
        }
        gCubeToken = httpServletRequest.getHeader("gcube-token");
        if (StringUtils.hasText((String)gCubeToken)) {
            this.logger.warn("Get token from gcube-token header");
            return gCubeToken;
        }
        String authorization = httpServletRequest.getHeader("Authorization");
        if (StringUtils.hasText((String)authorization) && StringUtils.startsWithIgnoreCase((String)authorization, (String)"Basic")) {
            this.logger.warn("Get token from basic authorization header");
            String base64Credentials = StringUtils.delete((String)authorization, (String)"Basic");
            String credentials = new String(Base64.getDecoder().decode(StringUtils.trimWhitespace((String)base64Credentials)));
            String[] values = credentials.split(":", 2);
            return values[1];
        }
        this.logger.warn("gcube-token not found in query-string, in header and in basic authorization header");
        gCubeToken = httpServletRequest.getParameter("password");
        if (StringUtils.hasText((String)gCubeToken)) {
            this.logger.warn("Get token from HTML form (in the password field)");
            String user = httpServletRequest.getParameter("username");
            this.logger.warn("Get username from HTML form: " + user);
            if (StringUtils.hasText((String)user) && user.equals(this.getUser(gCubeToken))) {
                return gCubeToken;
            }
            this.logger.warn("Username doesn't match with ClientInfo of gcube");
        } else {
            this.logger.warn("gcube-token also not found in the HTML form in the password field");
        }
        return null;
    }

    private String getEndpoint(String token) {
        try {
            AuthorizationEntry authorizationEntry = Constants.authorizationService().get(token);
            String scope = authorizationEntry.getContext();
            this.logger.warn("Set scope in to " + scope);
            ScopeProvider.instance.set(scope);
            SecurityTokenProvider.instance.set(token);
            String serviceClass = String.format("$resource/Profile/ServiceClass/text() eq '%s'", "SDI");
            String serviceName = String.format("$resource/Profile/ServiceName/text() eq '%s'", "sdi-service");
            String status = String.format("$resource/Profile/DeploymentData/Status/text() eq '%s'", "ready");
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class).addCondition(serviceClass).addCondition(serviceName).addCondition(status);
            DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
            List gCoreEndpoints = client.submit((Query)query);
            int size = gCoreEndpoints.size();
            this.logger.warn("gCoreEndpoints size = " + size);
            if (size > 0) {
                GCoreEndpoint gCoreEndpoint = (GCoreEndpoint)gCoreEndpoints.get(0);
                return ((GCoreEndpoint.Profile.Endpoint)gCoreEndpoint.profile().endpointMap().get("org.gcube.spatial.data.sdi.SDIService")).uri().toString();
            }
        }
        catch (Exception ex) {
            this.logger.error("Error in getEndpoint() method: " + ex.getMessage());
        }
        return null;
    }

    private String getUser(String token) {
        try {
            AuthorizationEntry authorizationEntry = Constants.authorizationService().get(token);
            return authorizationEntry.getClientInfo().getId();
        }
        catch (Exception ex) {
            this.logger.error("Error in getUser() method: " + ex.getMessage());
            return null;
        }
    }

    private boolean validateToken(String token) {
        this.logger.warn("Validate token in progress...");
        return true;
    }
}

