/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.connector.utils;

import java.util.ArrayList;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.LRUMap;

public class GCubeCache<K, T> {
    private long timeToLive;
    private LRUMap cacheMap;

    public GCubeCache(long timeToLive, final long timerInterval, int maxItems) {
        this.timeToLive = timeToLive * 1000L;
        this.cacheMap = new LRUMap(maxItems);
        if (timeToLive > 0L && timerInterval > 0L) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(timerInterval * 1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        GCubeCache.this.cleanup();
                    }
                }
            });
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, T value) {
        LRUMap lRUMap = this.cacheMap;
        synchronized (lRUMap) {
            this.cacheMap.put(key, (Object)new CacheObject(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(K key) {
        LRUMap lRUMap = this.cacheMap;
        synchronized (lRUMap) {
            CacheObject c = (CacheObject)this.cacheMap.get(key);
            if (c == null) {
                return null;
            }
            c.lastAccessed = System.currentTimeMillis();
            return c.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        LRUMap lRUMap = this.cacheMap;
        synchronized (lRUMap) {
            this.cacheMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LRUMap lRUMap = this.cacheMap;
        synchronized (lRUMap) {
            return this.cacheMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        long now = System.currentTimeMillis();
        ArrayList<Object> deleteKey = null;
        LRUMap lRUMap = this.cacheMap;
        synchronized (lRUMap) {
            MapIterator mapIterator = this.cacheMap.mapIterator();
            deleteKey = new ArrayList<Object>(this.cacheMap.size() / 2 + 1);
            Object key = null;
            CacheObject c = null;
            while (mapIterator.hasNext()) {
                key = mapIterator.next();
                c = (CacheObject)mapIterator.getValue();
                if (c == null || now <= this.timeToLive + c.lastAccessed) continue;
                deleteKey.add(key);
            }
        }
        for (Object e : deleteKey) {
            LRUMap lRUMap2 = this.cacheMap;
            synchronized (lRUMap2) {
                this.cacheMap.remove(e);
            }
            Thread.yield();
        }
    }

    protected class CacheObject {
        public long lastAccessed = System.currentTimeMillis();
        public T value;

        protected CacheObject(T value) {
            this.value = value;
        }
    }
}

