package org.gcube.spatial.data.clients.geoserver;

import java.util.List;

import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;

import org.gcube.spatial.data.clients.AbstractGenericRESTClient;
import org.gcube.spatial.data.clients.GenericLoginClient;
import org.gcube.spatial.data.clients.model.ConnectionDescriptor;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.faults.RemoteException;
import org.gcube.spatial.data.sdi.model.gn.LoginLevel;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.json.simple.JSONObject;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class GSRESTClientImpl extends AbstractGenericRESTClient implements GSRESTClient,GenericLoginClient{

	private static final String API_BASE_PATH="rest";
	
	private static final String WS_BASE_PATH="workspaces";
	private static final String DATASTORE_BASE_PATH="datastores";
	private static final String STYLES_BASE_PATH="styles";
	private static final String LAYERS_BASE_PATH="layers";
	
	static Configuration JSON_PATH_ALWAYS_LIST_CONFIG= Configuration.builder().options(Option.ALWAYS_RETURN_LIST,Option.SUPPRESS_EXCEPTIONS,Option.DEFAULT_PATH_LEAF_TO_NULL).build();

	
	
	
	
	public GSRESTClientImpl(ConnectionDescriptor conn) {
		super(conn);

		setBasePath(API_BASE_PATH);
		
//		log.info("Connecting to GS @ "+conn.getEndpoint());
//		
//		Credentials cr=conn.getCredentials().get(0);
//		log.debug("Using "+cr);
//		register(HttpAuthenticationFeature.universal(cr.getUsername(), cr.getPassword()));
		
		
	}

	
	
	
	@Override
	public void login() {
		
	}

	@Override
	public void login(LoginLevel lvl) {
		// TODO Auto-generated method stub
		
	}

	//************************** READ OPS
	
	
	@Override
	public JSONObject getWorkspaces() throws RemoteException,Exception {
		return get(WS_BASE_PATH);
	}

	@Override
	public JSONObject getWorkspace(String workspace) throws RemoteException, Exception {
		return get(WS_BASE_PATH+"/"+workspace);
	}
	
	@Override
	public JSONObject getDataStoresInWorkspace(String ws) throws RemoteException, Exception {
		return get(WS_BASE_PATH+"/"+ws+"/datastores");
	}

	@Override
	public JSONObject getStyles() throws RemoteException, Exception {
		return get(STYLES_BASE_PATH);
	}
	
	@Override
	public JSONObject getStylesByLayer(String layer) throws RemoteException, Exception {
		return get(LAYERS_BASE_PATH+"/"+layer+"/styles");
	}
	
	
	@Override
	public JSONObject getStylesInWorkspace(String ws) throws RemoteException, Exception {
		return get(WS_BASE_PATH+"/"+ws+"/styles");
	}

	@Override
	public List<String> getWorkspaceNames() throws RemoteException, Exception {
		DocumentContext sourceCtx=JsonPath.using(JSON_PATH_ALWAYS_LIST_CONFIG).parse(getWorkspaces().toString());
		return sourceCtx.read("$..name");
	}

	@Override
	public List<String> getDataStoresNamesInWorkspace(String ws) throws RemoteException, Exception {
		DocumentContext sourceCtx=JsonPath.using(JSON_PATH_ALWAYS_LIST_CONFIG).parse(getDataStoresInWorkspace(ws).toString());
		return sourceCtx.read("$..name");
	}

	@Override
	public List<String> getStylesNames() throws RemoteException, Exception {
		DocumentContext sourceCtx=JsonPath.using(JSON_PATH_ALWAYS_LIST_CONFIG).parse(getStyles().toString());
		return sourceCtx.read("$..name");
	}


	@Override
	public List<String> getStylesNamesinWorkspace(String ws) throws RemoteException, Exception {
		DocumentContext sourceCtx=JsonPath.using(JSON_PATH_ALWAYS_LIST_CONFIG).parse(getStylesInWorkspace(ws).toString());
		return sourceCtx.read("$..name");
	}


	@Override
	public List<String> getStylesNamesByLayer(String layer) throws RemoteException, Exception {
		DocumentContext sourceCtx=JsonPath.using(JSON_PATH_ALWAYS_LIST_CONFIG).parse(getStylesByLayer(layer).toString());
		return sourceCtx.read("$..name");
	}

	
	@Override
	public JSONObject getDataStore(String workspace, String dsName) throws RemoteException, Exception {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public String getSLD(String styleName) throws RemoteException, Exception {
		// TODO Auto-generated method stub
		return null;
	}
	
	//************* DELETE OPS 
	@Override
	public void deleteWorkspace(String ws) throws RemoteException, Exception {
		delete(WS_BASE_PATH+"/"+ws);
	}

	@Override
	public void deleteStyle(String style) throws RemoteException, Exception {
		delete(STYLES_BASE_PATH+"/"+style);
	}

	@Override
	public void deleteDataStore(String ds) throws RemoteException, Exception {
		delete(DATASTORE_BASE_PATH+"/"+ds);
	}

	@Override
	public void deleteLayer(String layer) throws RemoteException, Exception {
		delete(LAYERS_BASE_PATH+"/"+layer);
	}


	//************************* CREATE OPS
//	
//	@Override
//	public void createStyle(String name, String content) throws RemoteException, Exception {
//		// TODO Auto-generated method stub
//		
//	}
//	
	@Override
	public void createWorkspace(String ws) throws RemoteException, Exception {
		post(WS_BASE_PATH,Entity.entity(new JSONObject().put("name", ws),MediaType.APPLICATION_JSON));
	}




	@Override
	public boolean exist() {
		// TODO Auto-generated method stub
		return false;
	}




	
}
