/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.social_networking.socialutillibrary;

import java.io.StringWriter;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.gcube.social_networking.socialutillibrary.MessageParser;
import org.gcube.social_networking.socialutillibrary.SocialStringTokenizer;
import org.gcube.socialnetworking.token.Token;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageParserTest {
    private static final Logger logger = LoggerFactory.getLogger(MessageParserTest.class);
    public static final String TEST_11 = "Dear all, this is a test to ignore, to select a week for the upcoming 194th #Tcom event, hosted by #Apple in #Cupertino, please use this #Doodle: http://Doodle.com/poll/not-existing-poll \n\nWe're closing the poll next Thursday 16th March.";
    public static final String TEST_12 = "Just because I am so happy to have the SPARQL-endpoint available, \nsharing some sample SPARQL queries: \n\n* Classes & usage counts: \nhttps://virtuoso.parthenos.d4science.org/sparql?default-graph-uri=&query=%09SELECT+%3Fp+%28COUNT%28%3Fp%29+as+%3FpCount%29++%0D%0A%09%09%09%09%09WHERE+%7B%5B%5D+%3Fp+%5B%5D%7D%0D%0A%09%09%09%09%09GROUP+BY+%3Fp&format=text%2Fhtml&timeout=0&debug=on\n\n* properties and usage counts: \nhttps://virtuoso.parthenos.d4science.org/sparql?default-graph-uri=&query=SELECT+%3Ftype+%28COUNT%28%3Ftype%29+as+%3FtypeCount%29++%0D%0A%09%09%09%09%09WHERE+%7B%5B%5D+a+%3Ftype%7D%0D%0A%09%09%09%09%09GROUP+BY+%3Ftype&format=text%2Fhtml&timeout=0&debug=on\n";
    public static final String TEST_LUCA = "Dear members,\nThe item 'just a test with time fields' has been just published by Francesco Mangiacrapa .\nYou can find it here: http://data-d.d4science.org/ctlg/NextNext/just_a_test_with_time_fields\n#Text_mining #Field_1 #B3";

    @Test
    public void test() {
        String message = "Prova #Pippo Pollo http://google)     :)  ";
        MessageParser messageParser = new MessageParser(message);
        logger.debug(messageParser.getParsedMessage());
        messageParser = new MessageParser(TEST_11);
        logger.debug(messageParser.getParsedMessage());
        messageParser = new MessageParser(TEST_12);
        logger.debug(messageParser.getParsedMessage());
        messageParser = new MessageParser(TEST_LUCA);
        logger.debug(messageParser.getParsedMessage());
    }

    @Test
    public void aux() {
        String message = "Prova #Pippo Pollo http://google)     :)  ";
        SocialStringTokenizer socialStringTokenizer = new SocialStringTokenizer(message);
        List tokens = socialStringTokenizer.getTokens();
        logger.debug("{}", (Object)tokens);
        StringWriter stringWriter = new StringWriter();
        for (Token token : tokens) {
            stringWriter.append(token.getToken());
            stringWriter.append(token.getDelimiter());
        }
        Assert.assertTrue((message.compareTo(stringWriter.toString()) == 0 ? 1 : 0) != 0);
        logger.debug("\n'{}'\n'{}'", (Object)message, (Object)stringWriter.toString());
        logger.debug(new String(Base64.encodeBase64((byte[])"hashtagIdentificationParameter".getBytes())));
        logger.debug("hashtagIdentificationParameter");
        String hashtag = "#B3";
        logger.debug(new String(Base64.encodeBase64((byte[])hashtag.getBytes())));
        String taggedHTML = "<a class=\"link\" style=\"font-size:14px;\" href=\"?" + new String(Base64.encodeBase64((byte[])"hashtagIdentificationParameter".getBytes())) + "=" + new String(Base64.encodeBase64((byte[])hashtag.getBytes())) + "\">" + hashtag + "</a>";
        logger.debug(taggedHTML);
    }
}

