/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.cql.CqlAbstractExecutionImpl;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.reads.model.CqlColumnImpl;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.cql.util.CFQueryContext;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.query.ColumnQuery;

public class CqlColumnQueryImpl<C>
implements ColumnQuery<C> {
    private final CqlKeyspaceImpl.KeyspaceContext ksContext;
    private final CFQueryContext<?, C> cfContext;
    private final Object rowKey;
    private final C columnName;
    private boolean useCaching = false;
    private final CqlColumnFamilyDefinitionImpl cfDef;

    CqlColumnQueryImpl(CqlKeyspaceImpl.KeyspaceContext ksCtx, CFQueryContext<?, C> cfCtx, Object rowKey, C colName, boolean caching) {
        this.ksContext = ksCtx;
        this.cfContext = cfCtx;
        this.rowKey = rowKey;
        this.columnName = colName;
        this.useCaching = caching;
        ColumnFamily<?, C> cf = cfCtx.getColumnFamily();
        this.cfDef = (CqlColumnFamilyDefinitionImpl)cf.getColumnFamilyDefinition();
    }

    public OperationResult<Column<C>> execute() throws ConnectionException {
        return new InternalColumnQueryExecutionImpl(this).execute();
    }

    public ListenableFuture<OperationResult<Column<C>>> executeAsync() throws ConnectionException {
        return new InternalColumnQueryExecutionImpl(this).executeAsync();
    }

    public Object getRowKey() {
        return this.rowKey;
    }

    public C getColumnName() {
        return this.columnName;
    }

    public ColumnFamily<?, C> getCF() {
        return this.cfContext.getColumnFamily();
    }

    private class InternalColumnQueryExecutionImpl
    extends CqlAbstractExecutionImpl<Column<C>> {
        private final CqlColumnQueryImpl<?> columnQuery;

        public InternalColumnQueryExecutionImpl(CqlColumnQueryImpl<?> query) {
            super(CqlColumnQueryImpl.this.ksContext, CqlColumnQueryImpl.this.cfContext);
            this.columnQuery = query;
        }

        @Override
        public CassandraOperationType getOperationType() {
            return CassandraOperationType.GET_COLUMN;
        }

        @Override
        public Statement getQuery() {
            return CqlColumnQueryImpl.this.cfDef.getRowQueryGenerator().getQueryStatement(this.columnQuery, CqlColumnQueryImpl.this.useCaching);
        }

        @Override
        public Column<C> parseResultSet(ResultSet rs) throws NotFoundException {
            Row row = rs.one();
            if (row == null) {
                return null;
            }
            CqlColumnImpl<Object> cqlCol = new CqlColumnImpl<Object>(CqlColumnQueryImpl.this.columnName, row, 0);
            return cqlCol;
        }
    }
}

