/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.Cluster;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.HostStats;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class JavaDriverConnectionPoolMonitorImpl
implements ConnectionPoolMonitor {
    private final AtomicReference<Cluster> cluster = new AtomicReference();
    private MetricRegistryListener metricsRegListener = new MetricRegistryListener(){

        public void onGaugeAdded(String name, Gauge<?> gauge) {
        }

        public void onGaugeRemoved(String name) {
        }

        public void onCounterAdded(String name, Counter counter) {
        }

        public void onCounterRemoved(String name) {
        }

        public void onHistogramAdded(String name, Histogram histogram) {
        }

        public void onHistogramRemoved(String name) {
        }

        public void onMeterAdded(String name, Meter meter) {
        }

        public void onMeterRemoved(String name) {
        }

        public void onTimerAdded(String name, Timer timer) {
        }

        public void onTimerRemoved(String name) {
        }
    };

    public JavaDriverConnectionPoolMonitorImpl withJavaDriverMetricsRegistry(MetricRegistryListener metricsRegListener) {
        this.metricsRegListener = metricsRegListener;
        return this;
    }

    public MetricRegistryListener getMetricsRegistryListener() {
        return this.metricsRegListener;
    }

    public long getHostCount() {
        return ((Integer)this.cluster.get().getMetrics().getKnownHosts().getValue()).intValue();
    }

    public long getHostActiveCount() {
        return ((Integer)this.cluster.get().getMetrics().getConnectedToHosts().getValue()).intValue();
    }

    public long getNumOpenConnections() {
        return ((Integer)this.cluster.get().getMetrics().getOpenConnections().getValue()).intValue();
    }

    public long getConnectionCreateFailedCount() {
        return this.cluster.get().getMetrics().getErrorMetrics().getConnectionErrors().getCount();
    }

    public long getWriteTimeouts() {
        return this.cluster.get().getMetrics().getErrorMetrics().getWriteTimeouts().getCount();
    }

    public long getReadTimeouts() {
        return this.cluster.get().getMetrics().getErrorMetrics().getReadTimeouts().getCount();
    }

    public long getBadRequestCount() {
        return this.cluster.get().getMetrics().getErrorMetrics().getOthers().getCount();
    }

    public long notFoundCount() {
        return this.cluster.get().getMetrics().getErrorMetrics().getUnavailables().getCount();
    }

    public long getSocketTimeoutCount() {
        return this.cluster.get().getMetrics().getErrorMetrics().getIgnores().getCount();
    }

    public long getUnknownErrorCount() {
        return this.cluster.get().getMetrics().getErrorMetrics().getRetries().getCount();
    }

    public void incOperationFailure(Host host, Exception reason) {
    }

    public long getOperationFailureCount() {
        return 0L;
    }

    public void incFailover(Host host, Exception reason) {
    }

    public long getFailoverCount() {
        return 0L;
    }

    public void incOperationSuccess(Host host, long latency) {
    }

    public long getOperationSuccessCount() {
        return 0L;
    }

    public void incConnectionCreated(Host host) {
    }

    public long getConnectionCreatedCount() {
        return 0L;
    }

    public void incConnectionClosed(Host host, Exception reason) {
    }

    public long getConnectionClosedCount() {
        return 0L;
    }

    public void incConnectionCreateFailed(Host host, Exception reason) {
    }

    public void incConnectionBorrowed(Host host, long delay) {
    }

    public long getConnectionBorrowedCount() {
        return 0L;
    }

    public long getConnectionReturnedCount() {
        return 0L;
    }

    public void incConnectionReturned(Host host) {
    }

    public long getPoolExhaustedTimeoutCount() {
        return 0L;
    }

    public long getOperationTimeoutCount() {
        return 0L;
    }

    public long getNoHostCount() {
        return 0L;
    }

    public long getInterruptedCount() {
        return 0L;
    }

    public long getTransportErrorCount() {
        return 0L;
    }

    public long getHostAddedCount() {
        return 0L;
    }

    public long getHostRemovedCount() {
        return 0L;
    }

    public long getHostDownCount() {
        return 0L;
    }

    public void onHostAdded(Host host, HostConnectionPool<?> pool) {
    }

    public void onHostRemoved(Host host) {
    }

    public void onHostDown(Host host, Exception reason) {
    }

    public void onHostReactivated(Host host, HostConnectionPool<?> pool) {
    }

    public Map<Host, HostStats> getHostStats() {
        return null;
    }
}

