/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql;

import com.codahale.metrics.MetricRegistryListener;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.Clock;
import com.netflix.astyanax.ColumnMutation;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.KeyspaceTracerFactory;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.SerializerPackage;
import com.netflix.astyanax.clock.MicrosecondsAsyncClock;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.ConnectionPoolProxy;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.TokenRange;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.connectionpool.exceptions.OperationException;
import com.netflix.astyanax.connectionpool.impl.OperationResultImpl;
import com.netflix.astyanax.cql.CqlOperationResultImpl;
import com.netflix.astyanax.cql.CqlRingDescriber;
import com.netflix.astyanax.cql.CqlSchemaVersionReader;
import com.netflix.astyanax.cql.CqlStatement;
import com.netflix.astyanax.cql.JavaDriverConnectionPoolConfigurationImpl;
import com.netflix.astyanax.cql.JavaDriverConnectionPoolMonitorImpl;
import com.netflix.astyanax.cql.direct.DirectCqlStatement;
import com.netflix.astyanax.cql.reads.CqlColumnFamilyQueryImpl;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.cql.schema.CqlKeyspaceDefinitionImpl;
import com.netflix.astyanax.cql.util.CFQueryContext;
import com.netflix.astyanax.cql.writes.CqlColumnMutationImpl;
import com.netflix.astyanax.cql.writes.CqlMutationBatchImpl;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.ddl.KeyspaceDefinition;
import com.netflix.astyanax.ddl.SchemaChangeResult;
import com.netflix.astyanax.ddl.impl.SchemaChangeResponseImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.partitioner.BigInteger127Partitioner;
import com.netflix.astyanax.partitioner.Murmur3Partitioner;
import com.netflix.astyanax.partitioner.Partitioner;
import com.netflix.astyanax.query.ColumnFamilyQuery;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.serializers.SerializerPackageImpl;
import com.netflix.astyanax.serializers.UnknownComparatorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlKeyspaceImpl
implements Keyspace,
ConnectionPoolProxy.SeedHostListener {
    private static final Logger Logger = LoggerFactory.getLogger(CqlKeyspaceImpl.class);
    private final Clock clock;
    public volatile Cluster cluster;
    public volatile Session session;
    private final KeyspaceContext ksContext;
    private final String keyspaceName;
    private final AstyanaxConfiguration astyanaxConfig;
    private final KeyspaceTracerFactory tracerFactory;
    private final Configuration javaDriverConfig;
    private final ConnectionPoolMonitor cpMonitor;
    private final MetricRegistryListener metricsRegListener;

    public CqlKeyspaceImpl(String ksName, AstyanaxConfiguration asConfig, KeyspaceTracerFactory tracerFactory, ConnectionPoolConfiguration cpConfig, ConnectionPoolMonitor cpMonitor) {
        this(null, ksName, asConfig, tracerFactory, cpConfig, cpMonitor);
    }

    public CqlKeyspaceImpl(KeyspaceContext ksContext) {
        this(ksContext.getSession(), ksContext.getKeyspace(), ksContext.getConfig(), ksContext.getTracerFactory(), null, ksContext.getConnectionPoolMonitor());
    }

    CqlKeyspaceImpl(Session session, String ksName, AstyanaxConfiguration asConfig, KeyspaceTracerFactory tracerFactory, ConnectionPoolMonitor cpMonitor) {
        this(session, ksName, asConfig, tracerFactory, null, cpMonitor);
    }

    private CqlKeyspaceImpl(Session session, String ksName, AstyanaxConfiguration asConfig, KeyspaceTracerFactory tracerFactory, ConnectionPoolConfiguration cpConfig, ConnectionPoolMonitor cpMonitor) {
        this.session = session;
        this.keyspaceName = ksName.toLowerCase();
        this.astyanaxConfig = asConfig;
        this.tracerFactory = tracerFactory;
        this.cpMonitor = cpMonitor;
        this.metricsRegListener = ((JavaDriverConnectionPoolMonitorImpl)cpMonitor).getMetricsRegistryListener();
        this.ksContext = new KeyspaceContext(this);
        this.clock = asConfig.getClock() != null ? asConfig.getClock() : new MicrosecondsAsyncClock();
        this.javaDriverConfig = cpConfig != null ? ((JavaDriverConnectionPoolConfigurationImpl)cpConfig).getJavaDriverConfig() : null;
    }

    public AstyanaxConfiguration getConfig() {
        return this.astyanaxConfig;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public Partitioner getPartitioner() throws ConnectionException {
        String pName = this.describePartitioner();
        if (pName.contains("Murmur3Partitioner")) {
            return Murmur3Partitioner.get();
        }
        if (pName.contains("RandomPartitioner")) {
            return BigInteger127Partitioner.get();
        }
        throw new RuntimeException("Unrecognized partitioner: " + pName);
    }

    public String describePartitioner() throws ConnectionException {
        Select q = QueryBuilder.select((String[])new String[]{"partitioner"}).from("system", "local");
        ResultSet result = this.session.execute((Statement)q);
        Row row = result.one();
        if (row == null) {
            throw new RuntimeException("Missing paritioner");
        }
        String pName = row.getString(0);
        return pName;
    }

    public List<TokenRange> describeRing() throws ConnectionException {
        return CqlRingDescriber.getInstance().getTokenRanges(this.session, false);
    }

    public List<TokenRange> describeRing(String dc) throws ConnectionException {
        return CqlRingDescriber.getInstance().getTokenRanges(this.session, dc, null);
    }

    public List<TokenRange> describeRing(String dc, String rack) throws ConnectionException {
        return CqlRingDescriber.getInstance().getTokenRanges(this.session, dc, rack);
    }

    public List<TokenRange> describeRing(boolean cached) throws ConnectionException {
        return CqlRingDescriber.getInstance().getTokenRanges(this.session, cached);
    }

    public KeyspaceDefinition describeKeyspace() throws ConnectionException {
        Select.Where query = QueryBuilder.select().from("system", "schema_keyspaces").where(QueryBuilder.eq((String)"keyspace_name", (Object)this.keyspaceName));
        Row row = this.session.execute((Statement)query).one();
        if (row == null) {
            throw new RuntimeException("Keyspace not found: " + this.keyspaceName);
        }
        return new CqlKeyspaceDefinitionImpl(this.session, row);
    }

    public Properties getKeyspaceProperties() throws ConnectionException {
        try {
            return this.describeKeyspace().getProperties();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Properties getColumnFamilyProperties(String columnFamily) throws ConnectionException {
        KeyspaceDefinition ksDef = this.describeKeyspace();
        ColumnFamilyDefinition cfDef = ksDef.getColumnFamily(columnFamily);
        if (cfDef == null) {
            throw new NotFoundException(String.format("Column family '%s' in keyspace '%s' not found", columnFamily, this.getKeyspaceName()));
        }
        try {
            return cfDef.getProperties();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public SerializerPackage getSerializerPackage(String cfName, boolean ignoreErrors) throws ConnectionException, UnknownComparatorException {
        ColumnFamilyDefinition cfDef = this.describeKeyspace().getColumnFamily(cfName);
        return new SerializerPackageImpl(cfDef, ignoreErrors);
    }

    public MutationBatch prepareMutationBatch() {
        return new CqlMutationBatchImpl(this.ksContext, this.clock, this.astyanaxConfig.getDefaultWriteConsistencyLevel(), this.astyanaxConfig.getRetryPolicy());
    }

    public <K, C> ColumnMutation prepareColumnMutation(ColumnFamily<K, C> columnFamily, K rowKey, C column) {
        return new CqlColumnMutationImpl<K, C>(this.ksContext, new CFQueryContext<K, C>(columnFamily, rowKey), column);
    }

    public <K, C> ColumnFamilyQuery<K, C> prepareQuery(ColumnFamily<K, C> cf) {
        return new CqlColumnFamilyQueryImpl<K, C>(this.ksContext, cf);
    }

    public OperationResult<SchemaChangeResult> createKeyspace(Map<String, Object> options) throws ConnectionException {
        return new CqlKeyspaceDefinitionImpl(this.session, options).setName(this.keyspaceName).execute();
    }

    public OperationResult<SchemaChangeResult> createKeyspace(Properties properties) throws ConnectionException {
        return new CqlKeyspaceDefinitionImpl(this.session, properties).setName(this.keyspaceName).execute();
    }

    public OperationResult<SchemaChangeResult> createKeyspace(Map<String, Object> options, Map<ColumnFamily, Map<String, Object>> cfs) throws ConnectionException {
        CqlKeyspaceDefinitionImpl ksDef = new CqlKeyspaceDefinitionImpl(this.session, options);
        if (ksDef.getName() == null) {
            ksDef.setName(this.keyspaceName);
        }
        OperationResult<SchemaChangeResult> result = ksDef.execute();
        for (ColumnFamily cf : cfs.keySet()) {
            CqlColumnFamilyDefinitionImpl cfDef = new CqlColumnFamilyDefinitionImpl(this.session, ksDef.getName(), cf, cfs.get(cf));
            ksDef.addColumnFamily(cfDef);
        }
        return result;
    }

    public OperationResult<SchemaChangeResult> updateKeyspace(Map<String, Object> options) throws ConnectionException {
        return new CqlKeyspaceDefinitionImpl(this.session, options).setName(this.keyspaceName).alterKeyspace().execute();
    }

    public OperationResult<SchemaChangeResult> updateKeyspace(Properties props) throws ConnectionException {
        return new CqlKeyspaceDefinitionImpl(this.session, props).setName(this.keyspaceName).alterKeyspace().execute();
    }

    public OperationResult<SchemaChangeResult> dropKeyspace() throws ConnectionException {
        return new CqlOperationResultImpl<Object>(this.session.execute("DROP KEYSPACE " + this.keyspaceName), null);
    }

    public <K, C> OperationResult<Void> truncateColumnFamily(ColumnFamily<K, C> columnFamily) throws OperationException, ConnectionException {
        ResultSet result = this.session.execute("TRUNCATE " + this.keyspaceName + "." + columnFamily.getName());
        return new CqlOperationResultImpl<Object>(result, null);
    }

    public OperationResult<Void> truncateColumnFamily(String columnFamily) throws ConnectionException {
        ResultSet result = this.session.execute("TRUNCATE " + this.keyspaceName + "." + columnFamily);
        return new CqlOperationResultImpl<Object>(result, null);
    }

    public <K, C> OperationResult<SchemaChangeResult> createColumnFamily(ColumnFamily<K, C> columnFamily, Map<String, Object> options) throws ConnectionException {
        return new CqlColumnFamilyDefinitionImpl(this.session, this.keyspaceName, columnFamily, options).execute();
    }

    public OperationResult<SchemaChangeResult> createColumnFamily(Properties props) throws ConnectionException {
        return new CqlColumnFamilyDefinitionImpl(this.session, this.keyspaceName, props).execute();
    }

    public OperationResult<SchemaChangeResult> createColumnFamily(Map<String, Object> options) throws ConnectionException {
        return new CqlColumnFamilyDefinitionImpl(this.session, this.keyspaceName, options).execute();
    }

    public <K, C> OperationResult<SchemaChangeResult> updateColumnFamily(ColumnFamily<K, C> columnFamily, Map<String, Object> options) throws ConnectionException {
        return new CqlColumnFamilyDefinitionImpl(this.session, this.keyspaceName, columnFamily, options).alterTable().execute();
    }

    public OperationResult<SchemaChangeResult> updateColumnFamily(Properties props) throws ConnectionException {
        return new CqlColumnFamilyDefinitionImpl(this.session, this.keyspaceName, props).alterTable().execute();
    }

    public OperationResult<SchemaChangeResult> updateColumnFamily(Map<String, Object> options) throws ConnectionException {
        return new CqlColumnFamilyDefinitionImpl(this.session, this.keyspaceName, options).alterTable().execute();
    }

    public OperationResult<SchemaChangeResult> dropColumnFamily(String columnFamilyName) throws ConnectionException {
        return new CqlOperationResultImpl<Object>(this.session.execute("DROP TABLE " + this.keyspaceName + "." + columnFamilyName), null);
    }

    public <K, C> OperationResult<SchemaChangeResult> dropColumnFamily(ColumnFamily<K, C> columnFamily) throws ConnectionException {
        return this.dropColumnFamily(columnFamily.getName());
    }

    public Map<String, List<String>> describeSchemaVersions() throws ConnectionException {
        return new CqlSchemaVersionReader(this.session).exec();
    }

    public CqlStatement prepareCqlStatement() {
        return new DirectCqlStatement(this.session);
    }

    public ConnectionPool<?> getConnectionPool() throws ConnectionException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public OperationResult<Void> testOperation(Operation<?, ?> operation) throws ConnectionException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public OperationResult<Void> testOperation(Operation<?, ?> operation, RetryPolicy retry) throws ConnectionException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void setHosts(Collection<Host> hosts, int port) {
        try {
            if (this.session != null) {
                Logger.info("Session has already been set, SKIPPING SET HOSTS");
                return;
            }
            ArrayList hostList = Lists.newArrayList(hosts);
            List contactPoints = Lists.transform((List)hostList, (Function)new Function<Host, String>(){

                public String apply(Host input) {
                    if (input != null) {
                        return input.getHostName();
                    }
                    return null;
                }
            });
            Configuration config = this.javaDriverConfig;
            Logger.info("Using port: " + port);
            Cluster.Builder builder = Cluster.builder().addContactPoints(contactPoints.toArray(new String[0])).withPort(port).withLoadBalancingPolicy(config.getPolicies().getLoadBalancingPolicy()).withReconnectionPolicy(config.getPolicies().getReconnectionPolicy()).withRetryPolicy(config.getPolicies().getRetryPolicy()).withCompression(config.getProtocolOptions().getCompression()).withPoolingOptions(config.getPoolingOptions()).withSocketOptions(config.getSocketOptions()).withQueryOptions(config.getQueryOptions());
            if (config.getMetricsOptions() == null) {
                builder.withoutMetrics();
            } else if (!config.getMetricsOptions().isJMXReportingEnabled()) {
                builder.withoutJMXReporting();
            }
            this.cluster = builder.build();
            if (!(this.cpMonitor instanceof JavaDriverConnectionPoolMonitorImpl)) {
                this.cluster.getMetrics().getRegistry().addListener(this.metricsRegListener);
            }
            Logger.info("Connecting to cluster");
            this.session = this.cluster.connect();
            Logger.info("Done connecting to cluster, session object created");
        }
        catch (RuntimeException e) {
            Logger.error("Failed to set hosts for keyspace impl", (Throwable)e);
        }
        catch (Exception e) {
            Logger.error("Failed to set hosts for keyspace impl", (Throwable)e);
        }
    }

    public void shutdown() {
        this.cluster.close();
    }

    public OperationResult<SchemaChangeResult> createKeyspaceIfNotExists(final Map<String, Object> options) throws ConnectionException {
        return this.createKeyspaceIfNotExists(new Callable<OperationResult<SchemaChangeResult>>(){

            @Override
            public OperationResult<SchemaChangeResult> call() throws Exception {
                return CqlKeyspaceImpl.this.createKeyspace(options);
            }
        });
    }

    public OperationResult<SchemaChangeResult> createKeyspaceIfNotExists(final Properties properties) throws ConnectionException {
        return this.createKeyspaceIfNotExists(new Callable<OperationResult<SchemaChangeResult>>(){

            @Override
            public OperationResult<SchemaChangeResult> call() throws Exception {
                return CqlKeyspaceImpl.this.createKeyspace(properties);
            }
        });
    }

    public OperationResult<SchemaChangeResult> createKeyspaceIfNotExists(final Map<String, Object> options, final Map<ColumnFamily, Map<String, Object>> cfs) throws ConnectionException {
        return this.createKeyspaceIfNotExists(new Callable<OperationResult<SchemaChangeResult>>(){

            @Override
            public OperationResult<SchemaChangeResult> call() throws Exception {
                return CqlKeyspaceImpl.this.createKeyspace(options, cfs);
            }
        });
    }

    private OperationResult<SchemaChangeResult> createKeyspaceIfNotExists(Callable<OperationResult<SchemaChangeResult>> createKeyspace) throws ConnectionException {
        ResultSet result = this.session.execute("select * from system.local where keyspace_name = '" + this.keyspaceName + "'");
        List rows = result.all();
        if (rows != null && rows.isEmpty()) {
            return new OperationResultImpl(Host.NO_HOST, (Object)new SchemaChangeResponseImpl().setSchemaId("no-op"), 0L);
        }
        try {
            return createKeyspace.call();
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public class KeyspaceContext {
        private final Keyspace ks;

        public KeyspaceContext(Keyspace keyspaceCtx) {
            this.ks = keyspaceCtx;
        }

        public Session getSession() {
            return CqlKeyspaceImpl.this.session;
        }

        public String getKeyspace() {
            return CqlKeyspaceImpl.this.keyspaceName;
        }

        public AstyanaxConfiguration getConfig() {
            return CqlKeyspaceImpl.this.astyanaxConfig;
        }

        public KeyspaceTracerFactory getTracerFactory() {
            return CqlKeyspaceImpl.this.tracerFactory;
        }

        public Keyspace getKeyspaceContext() {
            return this.ks;
        }

        public ConnectionPoolMonitor getConnectionPoolMonitor() {
            return CqlKeyspaceImpl.this.cpMonitor;
        }
    }
}

