/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.tool.Tool;
import org.codehaus.jackson.JsonGenerator;

public class DataFileReadTool
implements Tool {
    @Override
    public String getName() {
        return "tojson";
    }

    @Override
    public String getShortDescription() {
        return "Dumps an Avro data file as JSON, one record per line.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        if (args.size() != 1) {
            err.println("Expected 1 argument: input_file.");
            return 1;
        }
        GenericDatumReader reader = new GenericDatumReader();
        DataFileReader fileReader = new DataFileReader(new File(args.get(0)), reader);
        try {
            Schema schema = fileReader.getSchema();
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            JsonEncoder encoder = new JsonEncoder(schema, (JsonGenerator)null);
            for (Object datum : fileReader) {
                ((Encoder)encoder).init(out);
                writer.write(datum, encoder);
                encoder.flush();
                out.println();
            }
            out.flush();
        }
        finally {
            fileReader.close();
        }
        return 0;
    }
}

