/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.ipc.Responder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;

public class SpecificResponder
extends Responder {
    private Object impl;
    private SpecificData data;

    public SpecificResponder(Class iface, Object impl) {
        this(SpecificData.get().getProtocol(iface), impl);
    }

    public SpecificResponder(Protocol protocol, Object impl) {
        this(protocol, impl, SpecificData.get());
    }

    protected SpecificResponder(Protocol protocol, Object impl, SpecificData data) {
        super(protocol);
        this.impl = impl;
        this.data = data;
    }

    protected DatumWriter<Object> getDatumWriter(Schema schema) {
        return new SpecificDatumWriter<Object>(schema);
    }

    protected DatumReader<Object> getDatumReader(Schema schema) {
        return new SpecificDatumReader<Object>(schema);
    }

    @Override
    public Object readRequest(Schema schema, Decoder in) throws IOException {
        Object[] args = new Object[schema.getFields().size()];
        int i = 0;
        for (Schema.Field param : schema.getFields()) {
            args[i++] = this.getDatumReader(param.schema()).read(null, in);
        }
        return args;
    }

    @Override
    public void writeResponse(Schema schema, Object response, Encoder out) throws IOException {
        this.getDatumWriter(schema).write(response, out);
    }

    @Override
    public void writeError(Schema schema, Object error, Encoder out) throws IOException {
        this.getDatumWriter(schema).write(error, out);
    }

    @Override
    public Object respond(Protocol.Message message, Object request) throws Exception {
        Class[] paramTypes = new Class[message.getRequest().getFields().size()];
        int i = 0;
        try {
            for (Schema.Field param : message.getRequest().getFields()) {
                paramTypes[i++] = this.data.getClass(param.schema());
            }
            Method method = this.impl.getClass().getMethod(message.getName(), paramTypes);
            method.setAccessible(true);
            return method.invoke(this.impl, (Object[])request);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
        catch (NoSuchMethodException e) {
            throw new AvroRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException(e);
        }
    }
}

