/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.trace.AvroTrace;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanAggregator;
import org.apache.avro.ipc.trace.Trace;
import org.apache.avro.ipc.trace.TraceCollection;
import org.apache.avro.specific.SpecificRequestor;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class TraceClientServlet
extends HttpServlet {
    private VelocityEngine velocityEngine = new VelocityEngine();
    private List<Span> activeSpans;
    private HashMap<Integer, TraceCollection> activeCollections = new HashMap();
    private String lastInput = "";

    public static Template getTemplate(VelocityEngine ve, String path) throws IOException {
        try {
            return ve.getTemplate(path);
        }
        catch (ResourceNotFoundException e) {
            throw new IOException();
        }
        catch (ParseErrorException e) {
            throw new IOException();
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    public TraceClientServlet() {
        this.activeSpans = new ArrayList<Span>();
        this.velocityEngine.addProperty("resource.loader", (Object)"class");
        this.velocityEngine.addProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        VelocityContext context = new VelocityContext();
        PrintWriter out = response.getWriter();
        String servers = request.getParameter("servers");
        if (servers != null) {
            String splitToken = System.getProperty("line.separator");
            this.lastInput = servers;
            if (splitToken == null) {
                splitToken = "\n";
            }
            String[] parts = servers.split(splitToken);
            LinkedList<URL> urls = new LinkedList<URL>();
            for (String p : parts) {
                String[] portHost = p.split(":");
                if (portHost.length != 2) continue;
                try {
                    URL url = new URL("http://" + p);
                    urls.add(url);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            List<Span> spans = this.collectAllSpans(urls);
            List<Span> merged = SpanAggregator.getFullSpans(spans).completeSpans;
            this.activeSpans.addAll(merged);
            List<Trace> traces = SpanAggregator.getTraces(merged).traces;
            List<TraceCollection> collections = SpanAggregator.getTraceCollections(traces);
            for (TraceCollection col : collections) {
                this.activeCollections.put(col.getExecutionPathHash(), col);
            }
            response.sendRedirect("/overview/");
        } else {
            out.println("No text entered.");
        }
    }

    protected List<Span> collectAllSpans(List<URL> hosts) {
        ArrayList<Span> out = new ArrayList<Span>();
        for (URL url : hosts) {
            HttpTransceiver trans = new HttpTransceiver(url);
            try {
                AvroTrace client = (AvroTrace)SpecificRequestor.getClient(AvroTrace.class, trans);
                for (Span s : client.getAllSpans()) {
                    out.add(s);
                }
            }
            catch (IOException e) {
            }
        }
        return out;
    }

    protected List<Span> collectRangedSpans(List<URL> hosts, long start, long end) {
        ArrayList<Span> out = new ArrayList<Span>();
        for (URL url : hosts) {
            HttpTransceiver trans = new HttpTransceiver(url);
            try {
                AvroTrace client = (AvroTrace)SpecificRequestor.getClient(AvroTrace.class, trans);
                for (Span s : client.getSpansInRange(start, end)) {
                    out.add(s);
                }
            }
            catch (IOException e) {
            }
        }
        return out;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        URL url = new URL(request.getRequestURL().toString());
        String path = url.getPath();
        String[] pathParts = path.split("/");
        if (pathParts.length == 0 || pathParts.length == 1) {
            this.loadSpans(out);
            return;
        }
        if (pathParts[1].equals("overview")) {
            this.overview(out);
            return;
        }
        if (pathParts[1].equals("collection")) {
            if (pathParts.length == 3) {
                int patternID = Integer.parseInt(pathParts[2]);
                this.collection(out, patternID);
                return;
            }
            if (pathParts.length == 4) {
                int patternID = Integer.parseInt(pathParts[2]);
                int nodeID = Integer.parseInt(pathParts[3]);
                this.collectionNode(out, patternID, nodeID);
                return;
            }
            response.sendRedirect("/");
            return;
        }
        response.sendRedirect("/");
    }

    private void overview(PrintWriter out) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("collections", this.activeCollections);
        context.put("spans", this.activeSpans);
        Template t = TraceClientServlet.getTemplate(this.velocityEngine, "org/apache/avro/ipc/trace/templates/overview.vm");
        t.merge((Context)context, (Writer)out);
    }

    private void collection(PrintWriter out, int patternID) throws IOException {
        VelocityContext context = new VelocityContext();
        TraceCollection col = this.activeCollections.get(patternID);
        context.put("collection", (Object)col);
        Template t = TraceClientServlet.getTemplate(this.velocityEngine, "org/apache/avro/ipc/trace/templates/collection.vm");
        t.merge((Context)context, (Writer)out);
    }

    private void collectionNode(PrintWriter out, int patternID, int nodeID) throws IOException {
        VelocityContext context = new VelocityContext();
        TraceCollection col = this.activeCollections.get(patternID);
        TraceCollection.TraceNodeStats node = col.getNodeWithID(nodeID);
        context.put("collection", (Object)col);
        context.put("node", (Object)node);
        Template t = TraceClientServlet.getTemplate(this.velocityEngine, "org/apache/avro/ipc/trace/templates/node.vm");
        t.merge((Context)context, (Writer)out);
    }

    private void loadSpans(PrintWriter out) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("last_input", (Object)this.lastInput);
        context.put("default_port", (Object)12335);
        Template t = TraceClientServlet.getTemplate(this.velocityEngine, "org/apache/avro/ipc/trace/templates/traceinput.vm");
        t.merge((Context)context, (Writer)out);
    }
}

