/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.Codec;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileConstants;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DecoderFactory;

public class DataFileStream<D>
implements Iterator<D>,
Iterable<D>,
Closeable {
    private Schema schema;
    private DatumReader<D> reader;
    private long blockSize;
    private boolean availableBlock = false;
    BinaryDecoder vin;
    BinaryDecoder datumIn = null;
    Map<String, byte[]> meta = new HashMap<String, byte[]>();
    ByteBuffer blockBuffer;
    long blockCount;
    long blockRemaining;
    byte[] sync = new byte[16];
    byte[] syncBuffer = new byte[16];
    private Codec codec;
    private DataBlock block = null;

    public DataFileStream(InputStream in, DatumReader<D> reader) throws IOException {
        this.reader = reader;
        this.initialize(in);
    }

    protected DataFileStream(DatumReader<D> reader) throws IOException {
        this.reader = reader;
    }

    void initialize(InputStream in) throws IOException {
        this.vin = DecoderFactory.defaultFactory().createBinaryDecoder(in, this.vin);
        byte[] magic = new byte[DataFileConstants.MAGIC.length];
        try {
            this.vin.readFixed(magic);
        }
        catch (IOException e) {
            throw new IOException("Not a data file.");
        }
        if (!Arrays.equals(DataFileConstants.MAGIC, magic)) {
            throw new IOException("Not a data file.");
        }
        long l = this.vin.readMapStart();
        if (l > 0L) {
            do {
                for (long i = 0L; i < l; ++i) {
                    String key = this.vin.readString(null).toString();
                    ByteBuffer value = this.vin.readBytes(null);
                    byte[] bb = new byte[value.remaining()];
                    value.get(bb);
                    this.meta.put(key, bb);
                }
            } while ((l = this.vin.mapNext()) != 0L);
        }
        this.vin.readFixed(this.sync);
        this.codec = this.resolveCodec();
        this.schema = Schema.parse(this.getMetaString("avro.schema"));
        this.reader.setSchema(this.schema);
    }

    Codec resolveCodec() {
        String codecStr = this.getMetaString("avro.codec");
        if (codecStr != null) {
            return CodecFactory.fromString(codecStr).createInstance();
        }
        return CodecFactory.nullCodec().createInstance();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public byte[] getMeta(String key) {
        return this.meta.get(key);
    }

    public String getMetaString(String key) {
        byte[] value = this.getMeta(key);
        if (value == null) {
            return null;
        }
        try {
            return new String(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public long getMetaLong(String key) {
        return Long.parseLong(this.getMetaString(key));
    }

    @Override
    public Iterator<D> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.blockRemaining == 0L) {
                boolean atEnd;
                if (null != this.datumIn && !(atEnd = this.datumIn.isEnd())) {
                    throw new IOException("Block read partially, the data may be corrupt");
                }
                if (this.hasNextBlock()) {
                    this.block = this.nextRawBlock(this.block);
                    this.block.decompressUsing(this.codec);
                    this.blockBuffer = this.block.getAsByteBuffer();
                    this.datumIn = DecoderFactory.defaultFactory().createBinaryDecoder(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position(), this.blockBuffer.remaining(), this.datumIn);
                }
            }
            return this.blockRemaining != 0L;
        }
        catch (EOFException e) {
            return false;
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    @Override
    public D next() {
        try {
            return this.next(null);
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    public D next(D reuse) throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        D result = this.reader.read(reuse, this.datumIn);
        if (0L == --this.blockRemaining) {
            this.blockFinished();
        }
        return result;
    }

    public ByteBuffer nextBlock() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.blockRemaining != this.blockCount) {
            throw new IllegalStateException("Not at block start.");
        }
        this.blockRemaining = 0L;
        this.datumIn = null;
        return this.blockBuffer;
    }

    public long getBlockCount() {
        return this.blockCount;
    }

    protected void blockFinished() throws IOException {
    }

    boolean hasNextBlock() {
        try {
            if (this.availableBlock) {
                return true;
            }
            if (this.vin.isEnd()) {
                return false;
            }
            this.blockRemaining = this.vin.readLong();
            this.blockSize = this.vin.readLong();
            if (this.blockSize > Integer.MAX_VALUE || this.blockSize < 0L) {
                throw new IOException("Block size invalid or too large for this implementation: " + this.blockSize);
            }
            this.blockCount = this.blockRemaining;
            this.availableBlock = true;
            return true;
        }
        catch (EOFException eof) {
            return false;
        }
        catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    DataBlock nextRawBlock(DataBlock reuse) throws IOException {
        if (!this.hasNextBlock()) {
            throw new NoSuchElementException();
        }
        if (reuse == null || reuse.data.length < (int)this.blockSize) {
            reuse = new DataBlock(this.blockRemaining, (int)this.blockSize);
        } else {
            reuse.numEntries = this.blockRemaining;
            reuse.blockSize = (int)this.blockSize;
        }
        this.vin.readFixed(reuse.data, 0, reuse.blockSize);
        this.vin.readFixed(this.syncBuffer);
        if (!Arrays.equals(this.syncBuffer, this.sync)) {
            throw new IOException("Invalid sync!");
        }
        this.availableBlock = false;
        return reuse;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.vin.inputStream().close();
    }

    static class DataBlock {
        private byte[] data;
        private long numEntries;
        private int blockSize;
        private int offset = 0;

        private DataBlock(long numEntries, int blockSize) {
            this.data = new byte[blockSize];
            this.numEntries = numEntries;
            this.blockSize = blockSize;
        }

        DataBlock(ByteBuffer block, long numEntries) {
            this.data = block.array();
            this.blockSize = block.remaining();
            this.offset = block.arrayOffset() + block.position();
            this.numEntries = numEntries;
        }

        byte[] getData() {
            return this.data;
        }

        long getNumEntries() {
            return this.numEntries;
        }

        int getBlockSize() {
            return this.blockSize;
        }

        ByteBuffer getAsByteBuffer() {
            return ByteBuffer.wrap(this.data, this.offset, this.blockSize);
        }

        void decompressUsing(Codec c) throws IOException {
            ByteBuffer result = c.decompress(this.getAsByteBuffer());
            this.data = result.array();
            this.blockSize = result.remaining();
        }

        void compressUsing(Codec c) throws IOException {
            ByteBuffer result = c.compress(this.getAsByteBuffer());
            this.data = result.array();
            this.blockSize = result.remaining();
        }

        void writeBlockTo(BinaryEncoder e, byte[] sync) throws IOException {
            e.writeLong(this.numEntries);
            e.writeLong(this.blockSize);
            e.writeFixed(this.data, this.offset, this.blockSize);
            e.writeFixed(sync);
        }
    }
}

