/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.utils.ByteBufferUtil;

public class IndexSummary {
    public static final IndexSummarySerializer serializer = new IndexSummarySerializer();
    private final long[] positions;
    private final byte[][] keys;
    private final IPartitioner partitioner;

    public IndexSummary(IPartitioner partitioner, byte[][] keys, long[] positions) {
        this.partitioner = partitioner;
        assert (keys != null && keys.length > 0);
        assert (keys.length == positions.length);
        this.keys = keys;
        this.positions = positions;
    }

    public byte[][] getKeys() {
        return this.keys;
    }

    public int binarySearch(RowPosition key) {
        int low = 0;
        int mid = this.keys.length;
        int high = mid - 1;
        int result = -1;
        while (low <= high) {
            mid = low + high >> 1;
            result = -this.partitioner.decorateKey(ByteBuffer.wrap(this.keys[mid])).compareTo(key);
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result < 0 ? 1 : 2);
    }

    public byte[] getKey(int index) {
        return this.keys[index];
    }

    public long getPosition(int index) {
        return this.positions[index];
    }

    public int size() {
        return this.positions.length;
    }

    public static class IndexSummarySerializer {
        public void serialize(IndexSummary t, DataOutput out) throws IOException {
            out.writeInt(DatabaseDescriptor.getIndexInterval());
            out.writeInt(t.keys.length);
            for (int i = 0; i < t.keys.length; ++i) {
                out.writeLong(t.getPosition(i));
                ByteBufferUtil.writeWithLength(t.keys[i], out);
            }
        }

        public IndexSummary deserialize(DataInput in, IPartitioner partitioner) throws IOException {
            if (in.readInt() != DatabaseDescriptor.getIndexInterval().intValue()) {
                throw new IOException("Cannot read the saved summary because Index Interval changed.");
            }
            int size = in.readInt();
            long[] positions = new long[size];
            byte[][] keys = new byte[size][];
            for (int i = 0; i < size; ++i) {
                positions[i] = in.readLong();
                int len = in.readInt();
                keys[i] = len == 0 ? new byte[]{} : ByteBufferUtil.readBytes(in, len);
            }
            return new IndexSummary(partitioner, keys, positions);
        }
    }
}

