/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Objects;
import java.io.File;
import java.util.EnumSet;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.utils.Pair;

public class Component {
    public static final char separator = '-';
    static final EnumSet<Type> TYPES = EnumSet.allOf(Type.class);
    public static final Component DATA = new Component(Type.DATA);
    public static final Component PRIMARY_INDEX = new Component(Type.PRIMARY_INDEX);
    public static final Component FILTER = new Component(Type.FILTER);
    public static final Component COMPACTED_MARKER = new Component(Type.COMPACTED_MARKER);
    public static final Component COMPRESSION_INFO = new Component(Type.COMPRESSION_INFO);
    public static final Component STATS = new Component(Type.STATS);
    public static final Component DIGEST = new Component(Type.DIGEST);
    public static final Component SUMMARY = new Component(Type.SUMMARY);
    public static final Component TOC = new Component(Type.TOC);
    public final Type type;
    public final String name;
    public final int hashCode;

    public Component(Type type) {
        this(type, type.repr);
        assert (type != Type.CUSTOM);
    }

    public Component(Type type, String name) {
        assert (name != null) : "Component name cannot be null";
        this.type = type;
        this.name = name;
        this.hashCode = Objects.hashCode((Object[])new Object[]{type, name});
    }

    public String name() {
        return this.name;
    }

    public static Pair<Descriptor, Component> fromFilename(File directory, String name) {
        Component component;
        Pair<Descriptor, String> path = Descriptor.fromFilename(directory, name);
        Type type = Type.fromRepresentation((String)path.right);
        switch (type) {
            case DATA: {
                component = DATA;
                break;
            }
            case PRIMARY_INDEX: {
                component = PRIMARY_INDEX;
                break;
            }
            case FILTER: {
                component = FILTER;
                break;
            }
            case COMPACTED_MARKER: {
                component = COMPACTED_MARKER;
                break;
            }
            case COMPRESSION_INFO: {
                component = COMPRESSION_INFO;
                break;
            }
            case STATS: {
                component = STATS;
                break;
            }
            case DIGEST: {
                component = DIGEST;
                break;
            }
            case SUMMARY: {
                component = SUMMARY;
                break;
            }
            case TOC: {
                component = TOC;
                break;
            }
            case CUSTOM: {
                component = new Component(Type.CUSTOM, (String)path.right);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Pair.create(path.left, component);
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Component)) {
            return false;
        }
        Component that = (Component)o;
        return this.type == that.type && this.name.equals(that.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static enum Type {
        DATA("Data.db"),
        PRIMARY_INDEX("Index.db"),
        FILTER("Filter.db"),
        COMPACTED_MARKER("Compacted"),
        COMPRESSION_INFO("CompressionInfo.db"),
        STATS("Statistics.db"),
        DIGEST("Digest.sha1"),
        SUMMARY("Summary.db"),
        TOC("TOC.txt"),
        CUSTOM(null);

        final String repr;

        private Type(String repr) {
            this.repr = repr;
        }

        static Type fromRepresentation(String repr) {
            for (Type type : TYPES) {
                if (!repr.equals(type.repr)) continue;
                return type;
            }
            return CUSTOM;
        }
    }
}

