/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.io.compress.ICompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyError;

public class SnappyCompressor
implements ICompressor {
    public static final SnappyCompressor instance = new SnappyCompressor();
    private static Logger logger = LoggerFactory.getLogger(SnappyCompressor.class);

    public static SnappyCompressor create(Map<String, String> compressionOptions) {
        Snappy.getNativeLibraryVersion();
        return instance;
    }

    public static boolean isAvailable() {
        try {
            SnappyCompressor.create(Collections.<String, String>emptyMap());
            return true;
        }
        catch (Exception e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        catch (SnappyError e) {
            return false;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    @Override
    public Set<String> supportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public int initialCompressedBufferLength(int chunkLength) {
        return Snappy.maxCompressedLength((int)chunkLength);
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, ICompressor.WrappedArray output, int outputOffset) throws IOException {
        return Snappy.rawCompress((Object)input, (int)inputOffset, (int)inputLength, (byte[])output.buffer, (int)outputOffset);
    }

    @Override
    public int uncompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        return Snappy.rawUncompress((byte[])input, (int)inputOffset, (int)inputLength, (Object)output, (int)outputOffset);
    }

    static {
        if (!SnappyCompressor.isAvailable()) {
            logger.warn("Cannot initialize native Snappy library. Compression on new tables will be disabled.");
        }
    }
}

