/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.context.jts;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.jts.DatelineRule;
import com.spatial4j.core.context.jts.JtsSpatialContextFactory;
import com.spatial4j.core.context.jts.ValidationRule;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import java.util.ArrayList;
import java.util.List;

public class JtsSpatialContext
extends SpatialContext {
    public static final JtsSpatialContext GEO;
    protected final GeometryFactory geometryFactory;
    protected final boolean allowMultiOverlap;
    protected final boolean useJtsPoint;
    protected final boolean useJtsLineString;
    protected final DatelineRule datelineRule;
    protected final ValidationRule validationRule;
    protected final boolean autoIndex;

    public JtsSpatialContext(JtsSpatialContextFactory factory) {
        super(factory);
        this.geometryFactory = factory.getGeometryFactory();
        this.allowMultiOverlap = factory.allowMultiOverlap;
        this.useJtsPoint = factory.useJtsPoint;
        this.useJtsLineString = factory.useJtsLineString;
        this.datelineRule = factory.datelineRule;
        this.validationRule = factory.validationRule;
        this.autoIndex = factory.autoIndex;
    }

    public boolean isAllowMultiOverlap() {
        return this.allowMultiOverlap;
    }

    public DatelineRule getDatelineRule() {
        return this.datelineRule;
    }

    public ValidationRule getValidationRule() {
        return this.validationRule;
    }

    public boolean isAutoIndex() {
        return this.autoIndex;
    }

    @Override
    public double normX(double x) {
        x = super.normX(x);
        return this.geometryFactory.getPrecisionModel().makePrecise(x);
    }

    @Override
    public double normY(double y) {
        y = super.normY(y);
        return this.geometryFactory.getPrecisionModel().makePrecise(y);
    }

    @Override
    public String toString(Shape shape) {
        if (shape instanceof JtsGeometry) {
            JtsGeometry jtsGeom = (JtsGeometry)shape;
            return jtsGeom.getGeom().toText();
        }
        return super.toString(shape);
    }

    public Geometry getGeometryFrom(Shape shape) {
        if (shape instanceof JtsGeometry) {
            return ((JtsGeometry)shape).getGeom();
        }
        if (shape instanceof JtsPoint) {
            return ((JtsPoint)shape).getGeom();
        }
        if (shape instanceof com.spatial4j.core.shape.Point) {
            com.spatial4j.core.shape.Point point = (com.spatial4j.core.shape.Point)shape;
            return this.geometryFactory.createPoint(new Coordinate(point.getX(), point.getY()));
        }
        if (shape instanceof Rectangle) {
            Rectangle r = (Rectangle)shape;
            if (r.getCrossesDateLine()) {
                ArrayList<Geometry> pair = new ArrayList<Geometry>(2);
                pair.add(this.geometryFactory.toGeometry(new Envelope(r.getMinX(), this.getWorldBounds().getMaxX(), r.getMinY(), r.getMaxY())));
                pair.add(this.geometryFactory.toGeometry(new Envelope(this.getWorldBounds().getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY())));
                return this.geometryFactory.buildGeometry(pair);
            }
            return this.geometryFactory.toGeometry(new Envelope(r.getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY()));
        }
        if (shape instanceof Circle) {
            Circle circle = (Circle)shape;
            if (circle.getBoundingBox().getCrossesDateLine()) {
                throw new IllegalArgumentException("Doesn't support dateline cross yet: " + circle);
            }
            GeometricShapeFactory gsf = new GeometricShapeFactory(this.geometryFactory);
            gsf.setSize(circle.getBoundingBox().getWidth());
            gsf.setNumPoints(100);
            gsf.setCentre(new Coordinate(circle.getCenter().getX(), circle.getCenter().getY()));
            return gsf.createCircle();
        }
        throw new InvalidShapeException("can't make Geometry from: " + shape);
    }

    public boolean useJtsPoint() {
        return this.useJtsPoint;
    }

    @Override
    public com.spatial4j.core.shape.Point makePoint(double x, double y) {
        if (!this.useJtsPoint()) {
            return super.makePoint(x, y);
        }
        this.verifyX(x);
        this.verifyY(y);
        Coordinate coord = Double.isNaN(x) ? null : new Coordinate(x, y);
        return new JtsPoint(this.geometryFactory.createPoint(coord), this);
    }

    public boolean useJtsLineString() {
        return this.useJtsLineString;
    }

    @Override
    public Shape makeLineString(List<com.spatial4j.core.shape.Point> points) {
        if (!this.useJtsLineString()) {
            return super.makeLineString(points);
        }
        Coordinate[] coords = new Coordinate[points.size()];
        for (int i = 0; i < coords.length; ++i) {
            com.spatial4j.core.shape.Point p = points.get(i);
            if (p instanceof JtsPoint) {
                JtsPoint jtsPoint = (JtsPoint)p;
                coords[i] = jtsPoint.getGeom().getCoordinate();
                continue;
            }
            coords[i] = new Coordinate(p.getX(), p.getY());
        }
        LineString lineString = this.geometryFactory.createLineString(coords);
        return this.makeShape((Geometry)lineString);
    }

    public Shape makeShapeFromGeometry(Geometry geom) {
        JtsGeometry jtsGeom;
        if (geom.getClass() == GeometryCollection.class) {
            ArrayList<Shape> shapes = new ArrayList<Shape>(geom.getNumGeometries());
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                Geometry geomN = geom.getGeometryN(i);
                shapes.add(this.makeShapeFromGeometry(geomN));
            }
            return this.makeCollection(shapes);
        }
        if (geom instanceof Point) {
            Point pt = (Point)geom;
            return this.makePoint(pt.getX(), pt.getY());
        }
        if (!this.useJtsLineString() && geom instanceof LineString) {
            LineString lineString = (LineString)geom;
            ArrayList<com.spatial4j.core.shape.Point> points = new ArrayList<com.spatial4j.core.shape.Point>(lineString.getNumPoints());
            for (int i = 0; i < lineString.getNumPoints(); ++i) {
                Coordinate coord = lineString.getCoordinateN(i);
                points.add(this.makePoint(coord.x, coord.y));
            }
            return this.makeLineString(points);
        }
        try {
            jtsGeom = this.makeShape(geom);
            if (this.getValidationRule() != ValidationRule.none) {
                jtsGeom.validate();
            }
        }
        catch (RuntimeException e) {
            if (this.getValidationRule() == ValidationRule.repairConvexHull) {
                jtsGeom = this.makeShape(geom.convexHull());
            }
            if (this.getValidationRule() == ValidationRule.repairBuffer0) {
                jtsGeom = this.makeShape(geom.buffer(0.0));
            }
            throw e;
        }
        if (this.isAutoIndex()) {
            jtsGeom.index();
        }
        return jtsGeom;
    }

    public JtsGeometry makeShape(Geometry geom, boolean dateline180Check, boolean allowMultiOverlap) {
        return new JtsGeometry(geom, this, dateline180Check, allowMultiOverlap);
    }

    public JtsGeometry makeShape(Geometry geom) {
        return this.makeShape(geom, this.datelineRule != DatelineRule.none, this.allowMultiOverlap);
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    @Override
    public String toString() {
        if (this.equals(GEO)) {
            return GEO.getClass().getSimpleName() + ".GEO";
        }
        return super.toString();
    }

    public Rectangle makeRectFromRectangularPoly(Geometry geom) {
        assert (geom.isRectangle());
        Envelope env = geom.getEnvelopeInternal();
        boolean crossesDateline = false;
        if (this.isGeo() && this.getDatelineRule() != DatelineRule.none) {
            if (this.getDatelineRule() == DatelineRule.ccwRect) {
                crossesDateline = !CGAlgorithms.isCCW((Coordinate[])geom.getCoordinates());
            } else {
                boolean bl = crossesDateline = env.getWidth() > 180.0;
            }
        }
        if (crossesDateline) {
            return this.makeRectangle(env.getMaxX(), env.getMinX(), env.getMinY(), env.getMaxY());
        }
        return this.makeRectangle(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY());
    }

    static {
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.geo = true;
        GEO = new JtsSpatialContext(factory);
    }
}

