/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.MetricsOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.Policies;

public class Configuration {
    private final Policies policies;
    private final ProtocolOptions protocolOptions;
    private final PoolingOptions poolingOptions;
    private final SocketOptions socketOptions;
    private final MetricsOptions metricsOptions;
    private final QueryOptions queryOptions;

    public Configuration() {
        this(new Policies(), new ProtocolOptions(), new PoolingOptions(), new SocketOptions(), new MetricsOptions(), new QueryOptions());
    }

    public Configuration(Policies policies, ProtocolOptions protocolOptions, PoolingOptions poolingOptions, SocketOptions socketOptions, MetricsOptions metricsOptions, QueryOptions queryOptions) {
        this.policies = policies;
        this.protocolOptions = protocolOptions;
        this.poolingOptions = poolingOptions;
        this.socketOptions = socketOptions;
        this.metricsOptions = metricsOptions;
        this.queryOptions = queryOptions;
    }

    void register(Cluster.Manager manager) {
        this.protocolOptions.register(manager);
        this.poolingOptions.register(manager);
        this.queryOptions.register(manager);
    }

    public Policies getPolicies() {
        return this.policies;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public ProtocolOptions getProtocolOptions() {
        return this.protocolOptions;
    }

    public PoolingOptions getPoolingOptions() {
        return this.poolingOptions;
    }

    public MetricsOptions getMetricsOptions() {
        return this.metricsOptions;
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }
}

