/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.reads.model.CqlRangeBuilder;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.query.RowQuery;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.TimeUUIDSerializer;
import com.netflix.astyanax.util.RangeBuilder;
import com.netflix.astyanax.util.TimeUUIDUtils;
import java.util.UUID;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TimeUUIDTests
extends KeyspaceTests {
    private static final Logger LOG = Logger.getLogger(TimeUUIDTests.class);
    public static ColumnFamily<String, UUID> CF_TIME_UUID = ColumnFamily.newColumnFamily((String)"TimeUUID1", (Serializer)StringSerializer.get(), (Serializer)TimeUUIDSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        TimeUUIDTests.initContext();
        keyspace.createColumnFamily(CF_TIME_UUID, null);
        CF_TIME_UUID.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_TIME_UUID);
    }

    @Test
    public void testTimeUUID() throws Exception {
        MutationBatch m = keyspace.prepareMutationBatch();
        UUID columnName = TimeUUIDUtils.getUniqueTimeUUIDinMillis();
        long columnTime = TimeUUIDUtils.getTimeFromUUID((UUID)columnName);
        String rowKey = "Key1";
        m.withRow(CF_TIME_UUID, (Object)rowKey).delete();
        m.execute();
        m.discardMutations();
        int startTime = 100;
        int endTime = 200;
        m.withRow(CF_TIME_UUID, (Object)rowKey).putColumn((Object)columnName, 42, null);
        for (int i = startTime; i < endTime; ++i) {
            LOG.info((Object)TimeUUIDUtils.getTimeUUID((long)(columnTime + (long)i)).toString());
            m.withRow(CF_TIME_UUID, (Object)rowKey).putColumn((Object)TimeUUIDUtils.getTimeUUID((long)(columnTime + (long)i)), i, null);
        }
        m.execute();
        OperationResult result = keyspace.prepareQuery(CF_TIME_UUID).getKey((Object)rowKey).getColumn((Object)columnName).execute();
        Assert.assertEquals((Object)columnName, (Object)((Column)result.getResult()).getName());
        Assert.assertTrue((((Column)result.getResult()).getIntegerValue() == 42 ? 1 : 0) != 0);
        OperationResult result2 = keyspace.prepareQuery(CF_TIME_UUID).getKey((Object)rowKey).execute();
        Assert.assertTrue((((ColumnList)result2.getResult()).size() >= endTime - startTime ? 1 : 0) != 0);
        result2 = keyspace.prepareQuery(CF_TIME_UUID).getKey((Object)rowKey).withColumnRange(new RangeBuilder().setLimit(10).setStart(TimeUUIDUtils.getTimeUUID((long)0L)).setEnd(TimeUUIDUtils.getTimeUUID((long)0x7FFFFFFFFFFFFFL)).build()).execute();
        Assert.assertEquals((int)10, (int)((ColumnList)result2.getResult()).size());
        RowQuery query = keyspace.prepareQuery(CF_TIME_UUID).getKey((Object)rowKey).withColumnRange((ByteBufferRange)new CqlRangeBuilder().setFetchSize(10).setStart((Object)TimeUUIDUtils.getTimeUUID((long)(columnTime + (long)startTime))).setEnd((Object)TimeUUIDUtils.getTimeUUID((long)(columnTime + (long)endTime))).build()).autoPaginate(true);
        int pageCount = 0;
        int rowCount = 0;
        try {
            OperationResult result3;
            LOG.info((Object)"starting pagination");
            while (!((ColumnList)(result3 = query.execute()).getResult()).isEmpty()) {
                ++pageCount;
                Assert.assertTrue((((ColumnList)result3.getResult()).size() <= 10 ? 1 : 0) != 0);
                rowCount += ((ColumnList)result3.getResult()).size();
                LOG.info((Object)"==== Block ====");
                for (Column column : (ColumnList)result3.getResult()) {
                    LOG.info((Object)("Column is " + column.getName()));
                }
            }
            Assert.assertTrue((String)("pagination complete:  " + pageCount), (pageCount >= 10 ? 1 : 0) != 0);
            Assert.assertTrue((String)"pagination complete ", (rowCount <= 100 ? 1 : 0) != 0);
        }
        catch (ConnectionException e) {
            Assert.fail();
            LOG.info((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    @Test
    public void testTimeUUID2() throws Exception {
        CF_TIME_UUID.describe(keyspace);
        MutationBatch m = keyspace.prepareMutationBatch();
        String rowKey = "Key2";
        m.withRow(CF_TIME_UUID, (Object)rowKey).delete();
        m.execute();
        m.discardMutations();
        long now = System.currentTimeMillis();
        long msecPerDay = 86400000L;
        for (int i = 0; i < 100; ++i) {
            m.withRow(CF_TIME_UUID, (Object)rowKey).putColumn((Object)TimeUUIDUtils.getTimeUUID((long)(now - (long)i * msecPerDay)), i, null);
        }
        m.execute();
        OperationResult result = keyspace.prepareQuery(CF_TIME_UUID).getKey((Object)rowKey).withColumnRange(new RangeBuilder().setLimit(100).setStart(TimeUUIDUtils.getTimeUUID((long)(now - 20L * msecPerDay))).build()).execute();
        Assert.assertTrue((((ColumnList)result.getResult()).size() >= 20 ? 1 : 0) != 0);
    }
}

