/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.recipes.uniqueness.NotUniqueException;
import com.netflix.astyanax.recipes.uniqueness.RowUniquenessConstraint;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import java.util.UUID;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class RowUniquenessConstraintTest
extends KeyspaceTests {
    public static ColumnFamily<Long, String> CF_UNIQUE_CONSTRAINT = ColumnFamily.newColumnFamily((String)"cfunique", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get());
    Supplier<String> UniqueColumnSupplier = new Supplier<String>(){

        public String get() {
            return UUID.randomUUID().toString();
        }
    };

    @BeforeClass
    public static void init() throws Exception {
        RowUniquenessConstraintTest.initContext();
        keyspace.createColumnFamily(CF_UNIQUE_CONSTRAINT, null);
        CF_UNIQUE_CONSTRAINT.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_UNIQUE_CONSTRAINT);
    }

    @Test
    public void testUnique() throws Exception {
        RowUniquenessConstraint unique = new RowUniquenessConstraint(keyspace, CF_UNIQUE_CONSTRAINT, (Object)1L, this.UniqueColumnSupplier).withConsistencyLevel(ConsistencyLevel.CL_ONE);
        unique.acquire();
        try {
            unique = new RowUniquenessConstraint(keyspace, CF_UNIQUE_CONSTRAINT, (Object)1L, this.UniqueColumnSupplier).withConsistencyLevel(ConsistencyLevel.CL_ONE);
            unique.acquire();
            Assert.fail((String)"Should have gotten a non-unique ex");
        }
        catch (NotUniqueException e) {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testUniqueAndRelease() throws Exception {
        RowUniquenessConstraint unique = new RowUniquenessConstraint(keyspace, CF_UNIQUE_CONSTRAINT, (Object)2L, this.UniqueColumnSupplier).withConsistencyLevel(ConsistencyLevel.CL_ONE);
        unique.acquire();
        unique.release();
        unique = new RowUniquenessConstraint(keyspace, CF_UNIQUE_CONSTRAINT, (Object)2L, this.UniqueColumnSupplier).withConsistencyLevel(ConsistencyLevel.CL_ONE);
        unique.acquire();
    }

    @Test
    public void testUniquenessWithCustomMutation() throws Exception {
        ColumnList result = (ColumnList)keyspace.prepareQuery(CF_UNIQUE_CONSTRAINT).getRow((Object)10L).execute().getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        RowUniquenessConstraint unique = new RowUniquenessConstraint(keyspace, CF_UNIQUE_CONSTRAINT, (Object)3L, this.UniqueColumnSupplier).withConsistencyLevel(ConsistencyLevel.CL_ONE);
        unique.acquireAndApplyMutation((Function)new Function<MutationBatch, Boolean>(){

            public Boolean apply(MutationBatch input) {
                input.withRow(CF_UNIQUE_CONSTRAINT, (Object)10L).putEmptyColumn((Object)"MyCustomColumn", null);
                return true;
            }
        });
        result = (ColumnList)keyspace.prepareQuery(CF_UNIQUE_CONSTRAINT).getRow((Object)10L).execute().getResult();
        Assert.assertFalse((boolean)result.isEmpty());
    }
}

