/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.serializers.AnnotatedCompositeSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.test.SessionEvent;
import com.netflix.astyanax.util.TimeUUIDUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ClickStreamTests
extends KeyspaceTests {
    public static AnnotatedCompositeSerializer<SessionEvent> SE_SERIALIZER = new AnnotatedCompositeSerializer(SessionEvent.class);
    public static ColumnFamily<String, SessionEvent> CF_CLICK_STREAM = ColumnFamily.newColumnFamily((String)"ClickStream", (Serializer)StringSerializer.get(), SE_SERIALIZER);

    @BeforeClass
    public static void init() throws Exception {
        ClickStreamTests.initContext();
        keyspace.createColumnFamily(CF_CLICK_STREAM, null);
        CF_CLICK_STREAM.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_CLICK_STREAM);
    }

    @Test
    public void testClickStream() throws Exception {
        MutationBatch m = keyspace.prepareMutationBatch();
        String userId = "UserId";
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (int j = 0; j < 10; ++j) {
            uuids.add(TimeUUIDUtils.getTimeUUID((long)j));
        }
        long timeCounter = 0L;
        for (int i = 0; i < 10; ++i) {
            String sessionId = "Session" + i;
            for (int j = 0; j < 10; ++j) {
                m.withRow(CF_CLICK_STREAM, (Object)userId).putColumn((Object)new SessionEvent(sessionId, (UUID)uuids.get(j)), Long.toString(timeCounter), null);
                ++timeCounter;
            }
        }
        m.execute();
        OperationResult result = keyspace.prepareQuery(CF_CLICK_STREAM).getKey((Object)userId).withColumnRange((ByteBufferRange)SE_SERIALIZER.buildRange().greaterThanEquals((Object)"Session3").lessThanEquals((Object)"Session5").build()).execute();
        Assert.assertEquals((long)30L, (long)((ColumnList)result.getResult()).size());
        result = keyspace.prepareQuery(CF_CLICK_STREAM).getKey((Object)userId).withColumnRange((ByteBufferRange)SE_SERIALIZER.buildRange().greaterThanEquals((Object)"Session3").lessThan((Object)"Session5").build()).execute();
        Assert.assertEquals((long)20L, (long)((ColumnList)result.getResult()).size());
        result = keyspace.prepareQuery(CF_CLICK_STREAM).getKey((Object)userId).withColumnRange((ByteBufferRange)SE_SERIALIZER.buildRange().greaterThan((Object)"Session3").lessThanEquals((Object)"Session5").build()).execute();
        Assert.assertEquals((long)20L, (long)((ColumnList)result.getResult()).size());
        result = keyspace.prepareQuery(CF_CLICK_STREAM).getKey((Object)userId).withColumnRange((ByteBufferRange)SE_SERIALIZER.buildRange().greaterThan((Object)"Session3").lessThan((Object)"Session5").build()).execute();
        Assert.assertEquals((long)10L, (long)((ColumnList)result.getResult()).size());
        result = keyspace.prepareQuery(CF_CLICK_STREAM).getKey((Object)userId).withColumnRange((ByteBufferRange)SE_SERIALIZER.buildRange().withPrefix((Object)"Session3").greaterThanEquals(uuids.get(2)).lessThanEquals(uuids.get(8)).build()).execute();
        Assert.assertEquals((long)7L, (long)((ColumnList)result.getResult()).size());
        result = keyspace.prepareQuery(CF_CLICK_STREAM).getKey((Object)userId).withColumnRange((ByteBufferRange)SE_SERIALIZER.buildRange().withPrefix((Object)"Session3").greaterThanEquals((Object)TimeUUIDUtils.getTimeUUID((long)2L)).lessThan((Object)TimeUUIDUtils.getTimeUUID((long)8L)).build()).execute();
        Assert.assertEquals((long)6L, (long)((ColumnList)result.getResult()).size());
        result = keyspace.prepareQuery(CF_CLICK_STREAM).getKey((Object)userId).withColumnRange((ByteBufferRange)SE_SERIALIZER.buildRange().withPrefix((Object)"Session3").greaterThan((Object)TimeUUIDUtils.getTimeUUID((long)2L)).lessThanEquals((Object)TimeUUIDUtils.getTimeUUID((long)8L)).build()).execute();
        Assert.assertEquals((long)6L, (long)((ColumnList)result.getResult()).size());
        result = keyspace.prepareQuery(CF_CLICK_STREAM).getKey((Object)userId).withColumnRange((ByteBufferRange)SE_SERIALIZER.buildRange().withPrefix((Object)"Session3").greaterThan((Object)TimeUUIDUtils.getTimeUUID((long)2L)).lessThan((Object)TimeUUIDUtils.getTimeUUID((long)8L)).build()).execute();
        Assert.assertEquals((long)5L, (long)((ColumnList)result.getResult()).size());
    }
}

