/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool;

import com.netflix.astyanax.connectionpool.ConnectionFactory;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.OperationException;
import com.netflix.astyanax.connectionpool.impl.Topology;
import com.netflix.astyanax.partitioner.Partitioner;
import com.netflix.astyanax.retry.RetryPolicy;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolProxy<T>
implements ConnectionPool<T> {
    private static final Logger Logger = LoggerFactory.getLogger(ConnectionPoolProxy.class);
    private AtomicReference<SeedHostListener> listener = new AtomicReference<Object>(null);
    private AtomicReference<Collection<Host>> lastHostList = new AtomicReference<Object>(null);
    private final ConnectionPoolConfiguration cpConfig;
    private final ConnectionPoolMonitor monitor;

    public ConnectionPoolProxy(ConnectionPoolConfiguration cpConfig, ConnectionFactory<T> connectionFactory, ConnectionPoolMonitor monitor) {
        this.cpConfig = cpConfig;
        this.monitor = monitor;
    }

    public ConnectionPoolConfiguration getConnectionPoolConfiguration() {
        return this.cpConfig;
    }

    public ConnectionPoolMonitor getConnectionPoolMonitor() {
        return this.monitor;
    }

    @Override
    public void setHosts(Collection<Host> hosts) {
        if (hosts != null) {
            Logger.info("Setting hosts for listener here: " + this.listener.getClass().getName() + "   " + hosts);
            this.lastHostList.set(hosts);
        }
        if (this.listener.get() != null) {
            Logger.info("Setting hosts for listener: " + this.listener.getClass().getName() + "   " + hosts);
            this.listener.get().setHosts(hosts, this.cpConfig.getPort());
        }
    }

    public Collection<Host> getHosts() {
        return this.lastHostList.get();
    }

    public void addListener(SeedHostListener listener) {
        this.listener.set(listener);
        if (this.lastHostList.get() != null) {
            this.listener.get().setHosts(this.lastHostList.get(), this.cpConfig.getPort());
        }
    }

    @Override
    public boolean addHost(Host host, boolean refresh) {
        return false;
    }

    @Override
    public boolean removeHost(Host host, boolean refresh) {
        return false;
    }

    @Override
    public boolean isHostUp(Host host) {
        return false;
    }

    @Override
    public boolean hasHost(Host host) {
        return false;
    }

    @Override
    public List<HostConnectionPool<T>> getActivePools() {
        return null;
    }

    @Override
    public List<HostConnectionPool<T>> getPools() {
        return null;
    }

    @Override
    public HostConnectionPool<T> getHostPool(Host host) {
        return null;
    }

    @Override
    public <R> OperationResult<R> executeWithFailover(Operation<T, R> op, RetryPolicy retry) throws ConnectionException, OperationException {
        return null;
    }

    @Override
    public void shutdown() {
        if (this.lastHostList.get() != null) {
            this.listener.get().shutdown();
        }
    }

    @Override
    public void start() {
    }

    @Override
    public Topology<T> getTopology() {
        return null;
    }

    @Override
    public Partitioner getPartitioner() {
        return null;
    }

    public static interface SeedHostListener {
        public void setHosts(Collection<Host> var1, int var2);

        public void shutdown();
    }
}

