/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.ConjunctionSpans;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;

abstract class ContainSpans
extends ConjunctionSpans {
    Spans sourceSpans;
    Spans bigSpans;
    Spans littleSpans;

    ContainSpans(SpanWeight weight, Similarity.SimScorer simScorer, Spans bigSpans, Spans littleSpans, Spans sourceSpans) {
        super(Arrays.asList(bigSpans, littleSpans), weight, simScorer);
        this.bigSpans = Objects.requireNonNull(bigSpans);
        this.littleSpans = Objects.requireNonNull(littleSpans);
        this.sourceSpans = Objects.requireNonNull(sourceSpans);
    }

    @Override
    public int startPosition() {
        return this.atFirstInCurrentDoc ? -1 : (this.oneExhaustedInCurrentDoc ? Integer.MAX_VALUE : this.sourceSpans.startPosition());
    }

    @Override
    public int endPosition() {
        return this.atFirstInCurrentDoc ? -1 : (this.oneExhaustedInCurrentDoc ? Integer.MAX_VALUE : this.sourceSpans.endPosition());
    }

    @Override
    public int width() {
        return this.sourceSpans.width();
    }

    @Override
    public void collect(SpanCollector collector) throws IOException {
        this.bigSpans.collect(collector);
        this.littleSpans.collect(collector);
    }
}

