/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.dualwrites;

import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.contrib.dualwrites.DualKeyspaceMetadata;
import com.netflix.astyanax.contrib.dualwrites.DualWritesStrategy;
import com.netflix.astyanax.contrib.dualwrites.WriteMetadata;
import com.netflix.astyanax.cql.CqlPreparedStatement;
import com.netflix.astyanax.cql.CqlStatementResult;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class DualWritesCqlPreparedStatement
implements CqlPreparedStatement {
    private final CqlPreparedStatement primary;
    private final CqlPreparedStatement secondary;
    private final DualWritesStrategy execStrategy;
    private final DualKeyspaceMetadata ksMd;

    public DualWritesCqlPreparedStatement(CqlPreparedStatement primaryCql, CqlPreparedStatement secondarycql, DualWritesStrategy strategy, DualKeyspaceMetadata keyspaceMd) {
        this.primary = primaryCql;
        this.secondary = secondarycql;
        this.execStrategy = strategy;
        this.ksMd = keyspaceMd;
    }

    public <V> CqlPreparedStatement withByteBufferValue(V value, Serializer<V> serializer) {
        this.primary.withByteBufferValue(value, serializer);
        this.secondary.withByteBufferValue(value, serializer);
        return this;
    }

    public CqlPreparedStatement withValue(ByteBuffer value) {
        this.primary.withValue(value);
        this.secondary.withValue(value);
        return this;
    }

    public CqlPreparedStatement withValues(List<ByteBuffer> value) {
        this.primary.withValues(value);
        this.secondary.withValues(value);
        return this;
    }

    public CqlPreparedStatement withStringValue(String value) {
        this.primary.withStringValue(value);
        this.secondary.withStringValue(value);
        return this;
    }

    public CqlPreparedStatement withIntegerValue(Integer value) {
        this.primary.withIntegerValue(value);
        this.secondary.withIntegerValue(value);
        return this;
    }

    public CqlPreparedStatement withBooleanValue(Boolean value) {
        this.primary.withBooleanValue(value);
        this.secondary.withBooleanValue(value);
        return this;
    }

    public CqlPreparedStatement withDoubleValue(Double value) {
        this.primary.withDoubleValue(value);
        this.secondary.withDoubleValue(value);
        return this;
    }

    public CqlPreparedStatement withLongValue(Long value) {
        this.primary.withLongValue(value);
        this.secondary.withLongValue(value);
        return this;
    }

    public CqlPreparedStatement withFloatValue(Float value) {
        this.primary.withFloatValue(value);
        this.secondary.withFloatValue(value);
        return this;
    }

    public CqlPreparedStatement withShortValue(Short value) {
        this.primary.withShortValue(value);
        this.secondary.withShortValue(value);
        return this;
    }

    public CqlPreparedStatement withUUIDValue(UUID value) {
        this.primary.withUUIDValue(value);
        this.secondary.withUUIDValue(value);
        return this;
    }

    public OperationResult<CqlStatementResult> execute() throws ConnectionException {
        WriteMetadata writeMd = new WriteMetadata(this.ksMd, null, null);
        return this.execStrategy.wrapExecutions(this.primary, this.secondary, (Collection<WriteMetadata>)Collections.singletonList(writeMd)).execute();
    }

    public ListenableFuture<OperationResult<CqlStatementResult>> executeAsync() throws ConnectionException {
        WriteMetadata writeMd = new WriteMetadata(this.ksMd, null, null);
        return this.execStrategy.wrapExecutions(this.primary, this.secondary, (Collection<WriteMetadata>)Collections.singletonList(writeMd)).executeAsync();
    }
}

