/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class TransportStats
implements Streamable,
ToXContent {
    private long serverOpen;
    private long rxCount;
    private long rxSize;
    private long txCount;
    private long txSize;

    TransportStats() {
    }

    public TransportStats(long serverOpen, long rxCount, long rxSize, long txCount, long txSize) {
        this.serverOpen = serverOpen;
        this.rxCount = rxCount;
        this.rxSize = rxSize;
        this.txCount = txCount;
        this.txSize = txSize;
    }

    public long serverOpen() {
        return this.serverOpen;
    }

    public long getServerOpen() {
        return this.serverOpen();
    }

    public long rxCount() {
        return this.rxCount;
    }

    public long getRxCount() {
        return this.rxCount();
    }

    public ByteSizeValue rxSize() {
        return new ByteSizeValue(this.rxSize);
    }

    public ByteSizeValue getRxSize() {
        return this.rxSize();
    }

    public long txCount() {
        return this.txCount;
    }

    public long getTxCount() {
        return this.txCount();
    }

    public ByteSizeValue txSize() {
        return new ByteSizeValue(this.txSize);
    }

    public ByteSizeValue getTxSize() {
        return this.txSize();
    }

    public static TransportStats readTransportStats(StreamInput in) throws IOException {
        TransportStats stats = new TransportStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.serverOpen = in.readVLong();
        this.rxCount = in.readVLong();
        this.rxSize = in.readVLong();
        this.txCount = in.readVLong();
        this.txSize = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.serverOpen);
        out.writeVLong(this.rxCount);
        out.writeVLong(this.rxSize);
        out.writeVLong(this.txCount);
        out.writeVLong(this.txSize);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.TRANSPORT);
        builder.field(Fields.SERVER_OPEN, this.serverOpen);
        builder.field(Fields.RX_COUNT, this.rxCount);
        builder.byteSizeField(Fields.RX_SIZE_IN_BYTES, Fields.RX_SIZE, this.rxSize);
        builder.field(Fields.TX_COUNT, this.txCount);
        builder.byteSizeField(Fields.TX_SIZE_IN_BYTES, Fields.TX_SIZE, this.txSize);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString TRANSPORT = new XContentBuilderString("transport");
        static final XContentBuilderString SERVER_OPEN = new XContentBuilderString("server_open");
        static final XContentBuilderString RX_COUNT = new XContentBuilderString("rx_count");
        static final XContentBuilderString RX_SIZE = new XContentBuilderString("rx_size");
        static final XContentBuilderString RX_SIZE_IN_BYTES = new XContentBuilderString("rx_size_in_bytes");
        static final XContentBuilderString TX_COUNT = new XContentBuilderString("tx_count");
        static final XContentBuilderString TX_SIZE = new XContentBuilderString("tx_size");
        static final XContentBuilderString TX_SIZE_IN_BYTES = new XContentBuilderString("tx_size_in_bytes");

        Fields() {
        }
    }
}

