/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.innerhits;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.support.BaseInnerHitBuilder;

public class InnerHitsBuilder
implements ToXContent {
    private Map<String, InnerHit> innerHits = new HashMap<String, InnerHit>();

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("inner_hits");
        for (Map.Entry<String, InnerHit> entry : this.innerHits.entrySet()) {
            builder.startObject(entry.getKey());
            entry.getValue().toXContent(builder, params);
            builder.endObject();
        }
        return builder.endObject();
    }

    public void addInnerHit(String name, InnerHit innerHit) {
        this.innerHits.put(name, innerHit);
    }

    public static class InnerHit
    extends BaseInnerHitBuilder<InnerHit> {
        private String path;
        private String type;

        public InnerHit setQuery(QueryBuilder query) {
            this.sourceBuilder().query(query);
            return this;
        }

        public InnerHit setPath(String path) {
            this.path = path;
            return this;
        }

        public InnerHit setType(String type) {
            this.type = type;
            return this;
        }

        public InnerHit addInnerHit(String name, InnerHit innerHit) {
            this.sourceBuilder().innerHitsBuilder().addInnerHit(name, innerHit);
            return this;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.path != null) {
                builder.startObject("path").startObject(this.path);
            } else {
                builder.startObject("type").startObject(this.type);
            }
            super.toXContent(builder, params);
            return builder.endObject().endObject();
        }
    }
}

