/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import com.carrotsearch.hppc.DoubleArrayList;
import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesMethod;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.InternalTDigestPercentiles;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParser;
import org.elasticsearch.search.internal.SearchContext;

public abstract class AbstractPercentilesParser
implements Aggregator.Parser {
    public static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    public static final ParseField METHOD_FIELD = new ParseField("method", new String[0]);
    public static final ParseField COMPRESSION_FIELD = new ParseField("compression", new String[0]);
    public static final ParseField NUMBER_SIGNIFICANT_DIGITS_FIELD = new ParseField("number_of_significant_value_digits", new String[0]);
    private boolean formattable;

    public AbstractPercentilesParser(boolean formattable) {
        this.formattable = formattable;
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        ValuesSourceParser<ValuesSource.Numeric> vsParser = ValuesSourceParser.numeric(aggregationName, InternalTDigestPercentiles.TYPE, context).formattable(this.formattable).build();
        double[] keys = null;
        boolean keyed = true;
        Double compression = null;
        Integer numberOfSignificantValueDigits = null;
        PercentilesMethod method = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (vsParser.token(currentFieldName, token, parser)) continue;
            if (token == XContentParser.Token.START_ARRAY) {
                if (context.parseFieldMatcher().match(currentFieldName, this.keysField())) {
                    DoubleArrayList values = new DoubleArrayList(10);
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        double value = parser.doubleValue();
                        values.add(value);
                    }
                    keys = values.toArray();
                    Arrays.sort(keys);
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if (context.parseFieldMatcher().match(currentFieldName, KEYED_FIELD)) {
                    keyed = parser.booleanValue();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (method != null) {
                    throw new SearchParseException(context, "Found multiple methods in [" + aggregationName + "]: [" + currentFieldName + "]. only one of [" + PercentilesMethod.TDIGEST.getName() + "] and [" + PercentilesMethod.HDR.getName() + "] may be used.", parser.getTokenLocation());
                }
                method = PercentilesMethod.resolveFromName(currentFieldName);
                if (method == null) {
                    throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].", parser.getTokenLocation());
                }
                switch (method) {
                    case TDIGEST: {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.VALUE_NUMBER) {
                                if (context.parseFieldMatcher().match(currentFieldName, COMPRESSION_FIELD)) {
                                    compression = parser.doubleValue();
                                    continue;
                                }
                                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
                            }
                            throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
                        }
                        break;
                    }
                    case HDR: {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.VALUE_NUMBER) {
                                if (context.parseFieldMatcher().match(currentFieldName, NUMBER_SIGNIFICANT_DIGITS_FIELD)) {
                                    numberOfSignificantValueDigits = parser.intValue();
                                    continue;
                                }
                                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
                            }
                            throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
                        }
                        break;
                    }
                }
                continue;
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].", parser.getTokenLocation());
        }
        if (method == null) {
            method = PercentilesMethod.TDIGEST;
        }
        switch (method) {
            case TDIGEST: {
                if (numberOfSignificantValueDigits != null) {
                    throw new SearchParseException(context, "[number_of_significant_value_digits] cannot be used with method [tdigest] in [" + aggregationName + "].", parser.getTokenLocation());
                }
                if (compression != null) break;
                compression = 100.0;
                break;
            }
            case HDR: {
                if (compression != null) {
                    throw new SearchParseException(context, "[compression] cannot be used with method [hdr] in [" + aggregationName + "].", parser.getTokenLocation());
                }
                if (numberOfSignificantValueDigits != null) break;
                numberOfSignificantValueDigits = 3;
                break;
            }
            default: {
                throw new SearchParseException(context, "Unknown value for [" + currentFieldName + "] in [" + aggregationName + "]: [" + (Object)((Object)method) + "].", parser.getTokenLocation());
            }
        }
        return this.buildFactory(context, aggregationName, vsParser.config(), keys, method, compression, numberOfSignificantValueDigits, keyed);
    }

    protected abstract AggregatorFactory buildFactory(SearchContext var1, String var2, ValuesSourceConfig<ValuesSource.Numeric> var3, double[] var4, PercentilesMethod var5, Double var6, Integer var7, boolean var8);

    protected abstract ParseField keysField();
}

