/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public class AggregatorFactories {
    public static final AggregatorFactories EMPTY = new Empty();
    private AggregatorFactory parent;
    private AggregatorFactory[] factories;
    private List<PipelineAggregatorFactory> pipelineAggregatorFactories;

    public static Builder builder() {
        return new Builder();
    }

    private AggregatorFactories(AggregatorFactory[] factories, List<PipelineAggregatorFactory> pipelineAggregators) {
        this.factories = factories;
        this.pipelineAggregatorFactories = pipelineAggregators;
    }

    public List<PipelineAggregator> createPipelineAggregators() throws IOException {
        ArrayList<PipelineAggregator> pipelineAggregators = new ArrayList<PipelineAggregator>();
        for (PipelineAggregatorFactory factory : this.pipelineAggregatorFactories) {
            pipelineAggregators.add(factory.create());
        }
        return pipelineAggregators;
    }

    public Aggregator[] createSubAggregators(Aggregator parent) throws IOException {
        Aggregator[] aggregators = new Aggregator[this.count()];
        for (int i = 0; i < this.factories.length; ++i) {
            boolean collectsFromSingleBucket = false;
            aggregators[i] = this.factories[i].create(parent.context(), parent, false);
        }
        return aggregators;
    }

    public Aggregator[] createTopLevelAggregators(AggregationContext ctx) throws IOException {
        Aggregator[] aggregators = new Aggregator[this.factories.length];
        for (int i = 0; i < this.factories.length; ++i) {
            boolean collectsFromSingleBucket = true;
            aggregators[i] = this.factories[i].create(ctx, null, true);
        }
        return aggregators;
    }

    public int count() {
        return this.factories.length;
    }

    void setParent(AggregatorFactory parent) {
        this.parent = parent;
        for (AggregatorFactory factory : this.factories) {
            factory.parent = parent;
        }
    }

    public void validate() {
        for (AggregatorFactory factory : this.factories) {
            factory.validate();
        }
        for (PipelineAggregatorFactory factory : this.pipelineAggregatorFactories) {
            factory.validate(this.parent, this.factories, this.pipelineAggregatorFactories);
        }
    }

    public static class Builder {
        private final Set<String> names = new HashSet<String>();
        private final List<AggregatorFactory> factories = new ArrayList<AggregatorFactory>();
        private final List<PipelineAggregatorFactory> pipelineAggregatorFactories = new ArrayList<PipelineAggregatorFactory>();

        public Builder addAggregator(AggregatorFactory factory) {
            if (!this.names.add(factory.name)) {
                throw new IllegalArgumentException("Two sibling aggregations cannot have the same name: [" + factory.name + "]");
            }
            this.factories.add(factory);
            return this;
        }

        public Builder addPipelineAggregator(PipelineAggregatorFactory pipelineAggregatorFactory) {
            this.pipelineAggregatorFactories.add(pipelineAggregatorFactory);
            return this;
        }

        public AggregatorFactories build() {
            if (this.factories.isEmpty() && this.pipelineAggregatorFactories.isEmpty()) {
                return EMPTY;
            }
            List<PipelineAggregatorFactory> orderedpipelineAggregators = this.resolvePipelineAggregatorOrder(this.pipelineAggregatorFactories, this.factories);
            return new AggregatorFactories(this.factories.toArray(new AggregatorFactory[this.factories.size()]), orderedpipelineAggregators);
        }

        private List<PipelineAggregatorFactory> resolvePipelineAggregatorOrder(List<PipelineAggregatorFactory> pipelineAggregatorFactories, List<AggregatorFactory> aggFactories) {
            HashMap<String, PipelineAggregatorFactory> pipelineAggregatorFactoriesMap = new HashMap<String, PipelineAggregatorFactory>();
            for (PipelineAggregatorFactory factory : pipelineAggregatorFactories) {
                pipelineAggregatorFactoriesMap.put(factory.getName(), factory);
            }
            HashMap<String, AggregatorFactory> aggFactoriesMap = new HashMap<String, AggregatorFactory>();
            for (AggregatorFactory aggFactory : aggFactories) {
                aggFactoriesMap.put(aggFactory.name, aggFactory);
            }
            LinkedList<PipelineAggregatorFactory> orderedPipelineAggregatorrs = new LinkedList<PipelineAggregatorFactory>();
            ArrayList<PipelineAggregatorFactory> unmarkedFactories = new ArrayList<PipelineAggregatorFactory>(pipelineAggregatorFactories);
            HashSet<PipelineAggregatorFactory> temporarilyMarked = new HashSet<PipelineAggregatorFactory>();
            while (!unmarkedFactories.isEmpty()) {
                PipelineAggregatorFactory factory = (PipelineAggregatorFactory)unmarkedFactories.get(0);
                this.resolvePipelineAggregatorOrder(aggFactoriesMap, pipelineAggregatorFactoriesMap, orderedPipelineAggregatorrs, unmarkedFactories, temporarilyMarked, factory);
            }
            return orderedPipelineAggregatorrs;
        }

        private void resolvePipelineAggregatorOrder(Map<String, AggregatorFactory> aggFactoriesMap, Map<String, PipelineAggregatorFactory> pipelineAggregatorFactoriesMap, List<PipelineAggregatorFactory> orderedPipelineAggregators, List<PipelineAggregatorFactory> unmarkedFactories, Set<PipelineAggregatorFactory> temporarilyMarked, PipelineAggregatorFactory factory) {
            if (temporarilyMarked.contains(factory)) {
                throw new IllegalArgumentException("Cyclical dependancy found with pipeline aggregator [" + factory.getName() + "]");
            }
            if (unmarkedFactories.contains(factory)) {
                String[] bucketsPaths;
                temporarilyMarked.add(factory);
                block0: for (String bucketsPath : bucketsPaths = factory.getBucketsPaths()) {
                    List<AggregationPath.PathElement> bucketsPathElements = AggregationPath.parse(bucketsPath).getPathElements();
                    String firstAggName = bucketsPathElements.get((int)0).name;
                    if (bucketsPath.equals("_count") || bucketsPath.equals("_key")) continue;
                    if (aggFactoriesMap.containsKey(firstAggName)) {
                        AggregatorFactory aggFactory = aggFactoriesMap.get(firstAggName);
                        for (int i = 1; i < bucketsPathElements.size(); ++i) {
                            AggregationPath.PathElement pathElement = bucketsPathElements.get(i);
                            String aggName = pathElement.name;
                            if (i == bucketsPathElements.size() - 1 && (aggName.equalsIgnoreCase("_key") || aggName.equals("_count"))) continue block0;
                            AggregatorFactory[] subFactories = aggFactory.factories.factories;
                            boolean foundSubFactory = false;
                            for (AggregatorFactory subFactory : subFactories) {
                                if (!aggName.equals(subFactory.name)) continue;
                                aggFactory = subFactory;
                                foundSubFactory = true;
                                break;
                            }
                            if (!foundSubFactory && i == bucketsPathElements.size() - 1) {
                                List subPipelineFactories = aggFactory.factories.pipelineAggregatorFactories;
                                for (PipelineAggregatorFactory subFactory : subPipelineFactories) {
                                    if (!aggName.equals(subFactory.name())) continue;
                                    foundSubFactory = true;
                                    break;
                                }
                            }
                            if (foundSubFactory) continue;
                            throw new IllegalArgumentException("No aggregation [" + aggName + "] found for path [" + bucketsPath + "]");
                        }
                        continue;
                    }
                    PipelineAggregatorFactory matchingFactory = pipelineAggregatorFactoriesMap.get(firstAggName);
                    if (matchingFactory != null) {
                        this.resolvePipelineAggregatorOrder(aggFactoriesMap, pipelineAggregatorFactoriesMap, orderedPipelineAggregators, unmarkedFactories, temporarilyMarked, matchingFactory);
                        continue;
                    }
                    throw new IllegalArgumentException("No aggregation found for path [" + bucketsPath + "]");
                }
                unmarkedFactories.remove(factory);
                temporarilyMarked.remove(factory);
                orderedPipelineAggregators.add(factory);
            }
        }

        AggregatorFactory[] getAggregatorFactories() {
            return this.factories.toArray(new AggregatorFactory[this.factories.size()]);
        }

        List<PipelineAggregatorFactory> getPipelineAggregatorFactories() {
            return this.pipelineAggregatorFactories;
        }
    }

    private static final class Empty
    extends AggregatorFactories {
        private static final AggregatorFactory[] EMPTY_FACTORIES = new AggregatorFactory[0];
        private static final Aggregator[] EMPTY_AGGREGATORS = new Aggregator[0];
        private static final List<PipelineAggregatorFactory> EMPTY_PIPELINE_AGGREGATORS = new ArrayList<PipelineAggregatorFactory>();

        private Empty() {
            super(EMPTY_FACTORIES, EMPTY_PIPELINE_AGGREGATORS);
        }

        @Override
        public Aggregator[] createSubAggregators(Aggregator parent) {
            return EMPTY_AGGREGATORS;
        }

        @Override
        public Aggregator[] createTopLevelAggregators(AggregationContext ctx) {
            return EMPTY_AGGREGATORS;
        }
    }
}

