/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;

public abstract class AbstractScriptParser<S extends Script> {
    protected abstract String parseInlineScript(XContentParser var1) throws IOException;

    protected abstract S createScript(String var1, ScriptService.ScriptType var2, String var3, Map<String, Object> var4);

    protected abstract S createSimpleScript(XContentParser var1) throws IOException;

    @Deprecated
    protected Map<String, ScriptService.ScriptType> getAdditionalScriptParameters() {
        return Collections.emptyMap();
    }

    public S parse(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return this.createSimpleScript(parser);
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new Script.ScriptParseException("expected a string value or an object, but found [{}] instead", new Object[]{token});
        }
        String script = null;
        ScriptService.ScriptType type = null;
        String lang = this.getDefaultScriptLang();
        Map<String, Object> params = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseFieldMatcher.match(currentFieldName, ScriptService.ScriptType.INLINE.getParseField()) || parseFieldMatcher.match(currentFieldName, ScriptService.SCRIPT_INLINE)) {
                type = ScriptService.ScriptType.INLINE;
                script = this.parseInlineScript(parser);
                continue;
            }
            if (parseFieldMatcher.match(currentFieldName, ScriptService.ScriptType.FILE.getParseField()) || parseFieldMatcher.match(currentFieldName, ScriptService.SCRIPT_FILE)) {
                type = ScriptService.ScriptType.FILE;
                if (token == XContentParser.Token.VALUE_STRING) {
                    script = parser.text();
                    continue;
                }
                throw new Script.ScriptParseException("expected a string value for field [{}], but found [{}]", new Object[]{currentFieldName, token});
            }
            if (parseFieldMatcher.match(currentFieldName, ScriptService.ScriptType.INDEXED.getParseField()) || parseFieldMatcher.match(currentFieldName, ScriptService.SCRIPT_ID)) {
                type = ScriptService.ScriptType.INDEXED;
                if (token == XContentParser.Token.VALUE_STRING) {
                    script = parser.text();
                    continue;
                }
                throw new Script.ScriptParseException("expected a string value for field [{}], but found [{}]", new Object[]{currentFieldName, token});
            }
            if (parseFieldMatcher.match(currentFieldName, Script.ScriptField.LANG) || parseFieldMatcher.match(currentFieldName, ScriptService.SCRIPT_LANG)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    lang = parser.text();
                    continue;
                }
                throw new Script.ScriptParseException("expected a string value for field [{}], but found [{}]", new Object[]{currentFieldName, token});
            }
            if (parseFieldMatcher.match(currentFieldName, Script.ScriptField.PARAMS)) {
                if (token == XContentParser.Token.START_OBJECT) {
                    params = parser.map();
                    continue;
                }
                throw new Script.ScriptParseException("expected an object for field [{}], but found [{}]", new Object[]{currentFieldName, token});
            }
            ScriptService.ScriptType paramScriptType = this.getAdditionalScriptParameters().get(currentFieldName);
            if (paramScriptType != null) {
                script = this.parseInlineScript(parser);
                type = paramScriptType;
                continue;
            }
            throw new Script.ScriptParseException("unexpected field [{}]", currentFieldName);
        }
        if (script == null) {
            throw new Script.ScriptParseException("expected one of [{}], [{}] or [{}] fields, but found none", ScriptService.ScriptType.INLINE.getParseField().getPreferredName(), ScriptService.ScriptType.FILE.getParseField().getPreferredName(), ScriptService.ScriptType.INDEXED.getParseField().getPreferredName());
        }
        assert (type != null) : "if script is not null, type should definitely not be null";
        return this.createScript(script, type, lang, params);
    }

    protected String getDefaultScriptLang() {
        return null;
    }

    public S parse(Map<String, Object> config, boolean removeMatchedEntries, ParseFieldMatcher parseFieldMatcher) {
        String script = null;
        ScriptService.ScriptType type = null;
        String lang = null;
        Map params = null;
        Iterator<Map.Entry<String, Object>> itr = config.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, Object> entry = itr.next();
            String parameterName = entry.getKey();
            Object parameterValue = entry.getValue();
            if (parseFieldMatcher.match(parameterName, Script.ScriptField.LANG) || parseFieldMatcher.match(parameterName, ScriptService.SCRIPT_LANG)) {
                if (parameterValue instanceof String || parameterValue == null) {
                    lang = (String)parameterValue;
                    if (!removeMatchedEntries) continue;
                    itr.remove();
                    continue;
                }
                throw new Script.ScriptParseException("Value must be of type String: [" + parameterName + "]", new Object[0]);
            }
            if (parseFieldMatcher.match(parameterName, Script.ScriptField.PARAMS)) {
                if (parameterValue instanceof Map || parameterValue == null) {
                    params = (Map)parameterValue;
                    if (!removeMatchedEntries) continue;
                    itr.remove();
                    continue;
                }
                throw new Script.ScriptParseException("Value must be of type String: [" + parameterName + "]", new Object[0]);
            }
            if (parseFieldMatcher.match(parameterName, ScriptService.ScriptType.INLINE.getParseField()) || parseFieldMatcher.match(parameterName, ScriptService.SCRIPT_INLINE)) {
                if (parameterValue instanceof String || parameterValue == null) {
                    script = (String)parameterValue;
                    type = ScriptService.ScriptType.INLINE;
                    if (!removeMatchedEntries) continue;
                    itr.remove();
                    continue;
                }
                throw new Script.ScriptParseException("Value must be of type String: [" + parameterName + "]", new Object[0]);
            }
            if (parseFieldMatcher.match(parameterName, ScriptService.ScriptType.FILE.getParseField()) || parseFieldMatcher.match(parameterName, ScriptService.SCRIPT_FILE)) {
                if (parameterValue instanceof String || parameterValue == null) {
                    script = (String)parameterValue;
                    type = ScriptService.ScriptType.FILE;
                    if (!removeMatchedEntries) continue;
                    itr.remove();
                    continue;
                }
                throw new Script.ScriptParseException("Value must be of type String: [" + parameterName + "]", new Object[0]);
            }
            if (!parseFieldMatcher.match(parameterName, ScriptService.ScriptType.INDEXED.getParseField()) && !parseFieldMatcher.match(parameterName, ScriptService.SCRIPT_ID)) continue;
            if (parameterValue instanceof String || parameterValue == null) {
                script = (String)parameterValue;
                type = ScriptService.ScriptType.INDEXED;
                if (!removeMatchedEntries) continue;
                itr.remove();
                continue;
            }
            throw new Script.ScriptParseException("Value must be of type String: [" + parameterName + "]", new Object[0]);
        }
        if (script == null) {
            throw new Script.ScriptParseException("expected one of [{}], [{}] or [{}] fields, but found none", ScriptService.ScriptType.INLINE.getParseField().getPreferredName(), ScriptService.ScriptType.FILE.getParseField().getPreferredName(), ScriptService.ScriptType.INDEXED.getParseField().getPreferredName());
        }
        assert (type != null) : "if script is not null, type should definitely not be null";
        return this.createScript(script, type, lang, params);
    }
}

