/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.termvectors;

import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestToXContentListener;
import org.elasticsearch.rest.action.termvectors.RestTermVectorsAction;

public class RestMultiTermVectorsAction
extends BaseRestHandler {
    @Inject
    public RestMultiTermVectorsAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mtermvectors", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        MultiTermVectorsRequest multiTermVectorsRequest = new MultiTermVectorsRequest();
        TermVectorsRequest template = new TermVectorsRequest();
        template.index(request.param("index"));
        template.type(request.param("type"));
        RestTermVectorsAction.readURIParameters(template, request);
        multiTermVectorsRequest.ids(Strings.commaDelimitedListToStringArray(request.param("ids")));
        multiTermVectorsRequest.add(template, RestActions.getRestContent(request));
        client.multiTermVectors(multiTermVectorsRequest, new RestToXContentListener<MultiTermVectorsResponse>(channel));
    }
}

