/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.warmer.get;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.warmer.get.GetWarmersRequest;
import org.elasticsearch.action.admin.indices.warmer.get.GetWarmersResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;

public class RestGetWarmerAction
extends BaseRestHandler {
    @Inject
    public RestGetWarmerAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_warmer/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_warmer/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_warmers/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_warmer/{name}", this);
    }

    @Override
    public void handleRequest(final RestRequest request, RestChannel channel, Client client) {
        final String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String[] types = Strings.splitStringByCommaToArray(request.param("type"));
        String[] names = request.paramAsStringArray("name", Strings.EMPTY_ARRAY);
        GetWarmersRequest getWarmersRequest = new GetWarmersRequest();
        ((GetWarmersRequest)((GetWarmersRequest)getWarmersRequest.indices(indices)).types(types)).warmers(names);
        getWarmersRequest.local(request.paramAsBoolean("local", getWarmersRequest.local()));
        getWarmersRequest.indicesOptions(IndicesOptions.fromRequest(request, getWarmersRequest.indicesOptions()));
        client.admin().indices().getWarmers(getWarmersRequest, (ActionListener<GetWarmersResponse>)new RestBuilderListener<GetWarmersResponse>(channel){

            @Override
            public RestResponse buildResponse(GetWarmersResponse response, XContentBuilder builder) throws Exception {
                if (indices.length > 0 && response.warmers().isEmpty()) {
                    return new BytesRestResponse(RestStatus.OK, builder.startObject().endObject());
                }
                builder.startObject();
                for (ObjectObjectCursor<String, List<IndexWarmersMetaData.Entry>> objectObjectCursor : response.warmers()) {
                    builder.startObject((String)objectObjectCursor.key, XContentBuilder.FieldCaseConversion.NONE);
                    builder.startObject("warmers", XContentBuilder.FieldCaseConversion.NONE);
                    for (IndexWarmersMetaData.Entry warmerEntry : (List)objectObjectCursor.value) {
                        IndexWarmersMetaData.toXContent(warmerEntry, builder, request);
                    }
                    builder.endObject();
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

