/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.indices.breaker.CircuitBreakerStats;

public class AllCircuitBreakerStats
implements Streamable,
ToXContent {
    private CircuitBreakerStats[] allStats = new CircuitBreakerStats[0];

    public AllCircuitBreakerStats() {
    }

    public AllCircuitBreakerStats(CircuitBreakerStats[] allStats) {
        this.allStats = allStats;
    }

    public CircuitBreakerStats[] getAllStats() {
        return this.allStats;
    }

    public CircuitBreakerStats getStats(String name) {
        for (CircuitBreakerStats stats : this.allStats) {
            if (!stats.getName().equals(name)) continue;
            return stats;
        }
        return null;
    }

    public static AllCircuitBreakerStats readOptionalAllCircuitBreakerStats(StreamInput in) throws IOException {
        AllCircuitBreakerStats stats = in.readOptionalStreamable(new AllCircuitBreakerStats());
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int statCount = in.readVInt();
        CircuitBreakerStats[] newStats = new CircuitBreakerStats[statCount];
        for (int i = 0; i < statCount; ++i) {
            CircuitBreakerStats stats = new CircuitBreakerStats();
            stats.readFrom(in);
            newStats[i] = stats;
        }
        this.allStats = newStats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.allStats.length);
        for (CircuitBreakerStats stats : this.allStats) {
            if (stats == null) continue;
            stats.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.BREAKERS);
        for (CircuitBreakerStats stats : this.allStats) {
            if (stats == null) continue;
            stats.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString BREAKERS = new XContentBuilderString("breakers");

        Fields() {
        }
    }
}

