/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class TermsQueryBuilder
extends QueryBuilder
implements BoostableQueryBuilder<TermsQueryBuilder> {
    private final String name;
    private final Object values;
    private String minimumShouldMatch;
    private Boolean disableCoord;
    private String queryName;
    private float boost = -1.0f;

    public TermsQueryBuilder(String name, String ... values) {
        this(name, (Object[])values);
    }

    public TermsQueryBuilder(String name, int ... values) {
        this.name = name;
        this.values = values;
    }

    public TermsQueryBuilder(String name, long ... values) {
        this.name = name;
        this.values = values;
    }

    public TermsQueryBuilder(String name, float ... values) {
        this.name = name;
        this.values = values;
    }

    public TermsQueryBuilder(String name, double ... values) {
        this.name = name;
        this.values = values;
    }

    public TermsQueryBuilder(String name, Object ... values) {
        this.name = name;
        this.values = values;
    }

    public TermsQueryBuilder(String name, Iterable values) {
        this.name = name;
        this.values = values;
    }

    @Deprecated
    public TermsQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    @Deprecated
    public TermsQueryBuilder disableCoord(boolean disableCoord) {
        this.disableCoord = disableCoord;
        return this;
    }

    public TermsQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    public TermsQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("terms");
        builder.field(this.name, this.values);
        if (this.minimumShouldMatch != null) {
            builder.field("minimum_should_match", this.minimumShouldMatch);
        }
        if (this.disableCoord != null) {
            builder.field("disable_coord", (Object)this.disableCoord);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

