/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.percolator;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.percolator.PercolatorQueriesRegistry;

final class QueriesLoaderCollector
extends SimpleCollector {
    private final Map<BytesRef, Query> queries = Maps.newHashMap();
    private final FieldsVisitor fieldsVisitor = new FieldsVisitor(true);
    private final PercolatorQueriesRegistry percolator;
    private final IndexFieldData<?> uidFieldData;
    private final ESLogger logger;
    private SortedBinaryDocValues uidValues;
    private LeafReader reader;

    QueriesLoaderCollector(PercolatorQueriesRegistry percolator, ESLogger logger, MapperService mapperService, IndexFieldDataService indexFieldDataService) {
        this.percolator = percolator;
        this.logger = logger;
        MappedFieldType uidMapper = mapperService.smartNameFieldType("_uid");
        this.uidFieldData = indexFieldDataService.getForField(uidMapper);
    }

    public Map<BytesRef, Query> queries() {
        return this.queries;
    }

    public void collect(int doc) throws IOException {
        this.uidValues.setDocument(doc);
        if (this.uidValues.count() > 0) {
            assert (this.uidValues.count() == 1);
            BytesRef uid = this.uidValues.valueAt(0);
            BytesRef id = Uid.splitUidIntoTypeAndId(uid)[1];
            this.fieldsVisitor.reset();
            this.reader.document(doc, (StoredFieldVisitor)this.fieldsVisitor);
            try {
                Query parseQuery = this.percolator.parsePercolatorDocument(null, this.fieldsVisitor.source());
                if (parseQuery != null) {
                    this.queries.put(BytesRef.deepCopyOf((BytesRef)id), parseQuery);
                } else {
                    this.logger.warn("failed to add query [{}] - parser returned null", id);
                }
            }
            catch (Exception e) {
                this.logger.warn("failed to add query [{}]", e, id.utf8ToString());
            }
        }
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.reader = context.reader();
        this.uidValues = this.uidFieldData.load(context).getBytesValues();
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public boolean needsScores() {
        return false;
    }
}

