/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.MappedFieldType;

public class FieldDataType {
    public static final String FORMAT_KEY = "format";
    public static final String DOC_VALUES_FORMAT_VALUE = "doc_values";
    private final String type;
    private final String typeFormat;
    private final MappedFieldType.Loading loading;
    private final Settings settings;

    public FieldDataType(String type) {
        this(type, Settings.Builder.EMPTY_SETTINGS);
    }

    public FieldDataType(String type, Settings.Builder builder) {
        this(type, builder.build());
    }

    public FieldDataType(String type, Settings settings) {
        this.type = type;
        this.typeFormat = "index.fielddata.type." + type + "." + FORMAT_KEY;
        this.settings = settings;
        String loading = settings.get("loading");
        this.loading = MappedFieldType.Loading.parse(loading, MappedFieldType.Loading.LAZY);
    }

    public String getType() {
        return this.type;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public MappedFieldType.Loading getLoading() {
        return this.loading;
    }

    public String getFormat(Settings indexSettings) {
        String format = this.settings.get(FORMAT_KEY);
        if (format == null && indexSettings != null) {
            format = indexSettings.get(this.typeFormat);
        }
        return format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDataType that = (FieldDataType)o;
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.settings.hashCode();
        return result;
    }
}

