/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.common.io.stream.FilterStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;

public class NamedWriteableAwareStreamInput
extends FilterStreamInput {
    private final NamedWriteableRegistry namedWriteableRegistry;

    public NamedWriteableAwareStreamInput(StreamInput delegate, NamedWriteableRegistry namedWriteableRegistry) {
        super(delegate);
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    @Override
    <C> C readNamedWriteable(Class<C> categoryClass) throws IOException {
        String name = this.readString();
        NamedWriteable<C> namedWriteable = this.namedWriteableRegistry.getPrototype(categoryClass, name);
        return (C)namedWriteable.readFrom(this);
    }
}

