/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldstats;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.elasticsearch.action.fieldstats.FieldStatsRequest;
import org.elasticsearch.action.fieldstats.IndexConstraint;
import org.elasticsearch.action.support.broadcast.BroadcastShardRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class FieldStatsShardRequest
extends BroadcastShardRequest {
    private String[] fields;

    public FieldStatsShardRequest() {
    }

    public FieldStatsShardRequest(ShardId shardId, FieldStatsRequest request) {
        super(shardId, request);
        HashSet<String> fields = new HashSet<String>();
        fields.addAll(Arrays.asList(request.getFields()));
        for (IndexConstraint indexConstraint : request.getIndexConstraints()) {
            fields.add(indexConstraint.getField());
        }
        this.fields = fields.toArray(new String[fields.size()]);
    }

    public String[] getFields() {
        return this.fields;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.fields = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.fields);
    }
}

