/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.shard.ShardPath;

public class ShardStats
implements Streamable,
ToXContent {
    private ShardRouting shardRouting;
    private CommonStats commonStats;
    @Nullable
    private CommitStats commitStats;
    private String dataPath;
    private String statePath;
    private boolean isCustomDataPath;

    ShardStats() {
    }

    public ShardStats(ShardRouting routing, ShardPath shardPath, CommonStats commonStats, CommitStats commitStats) {
        this.shardRouting = routing;
        this.dataPath = shardPath.getRootDataPath().toString();
        this.statePath = shardPath.getRootStatePath().toString();
        this.isCustomDataPath = shardPath.isCustomDataPath();
        this.commitStats = commitStats;
        this.commonStats = commonStats;
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public CommonStats getStats() {
        return this.commonStats;
    }

    public CommitStats getCommitStats() {
        return this.commitStats;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getStatePath() {
        return this.statePath;
    }

    public boolean isCustomDataPath() {
        return this.isCustomDataPath;
    }

    public static ShardStats readShardStats(StreamInput in) throws IOException {
        ShardStats stats = new ShardStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.shardRouting = ShardRouting.readShardRoutingEntry(in);
        this.commonStats = CommonStats.readCommonStats(in);
        this.commitStats = CommitStats.readOptionalCommitStatsFrom(in);
        this.statePath = in.readString();
        this.dataPath = in.readString();
        this.isCustomDataPath = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardRouting.writeTo(out);
        this.commonStats.writeTo(out);
        out.writeOptionalStreamable(this.commitStats);
        out.writeString(this.statePath);
        out.writeString(this.dataPath);
        out.writeBoolean(this.isCustomDataPath);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.ROUTING).field(Fields.STATE, (Object)this.shardRouting.state()).field(Fields.PRIMARY, this.shardRouting.primary()).field(Fields.NODE, this.shardRouting.currentNodeId()).field(Fields.RELOCATING_NODE, this.shardRouting.relocatingNodeId()).endObject();
        this.commonStats.toXContent(builder, params);
        if (this.commitStats != null) {
            this.commitStats.toXContent(builder, params);
        }
        builder.startObject(Fields.SHARD_PATH);
        builder.field(Fields.STATE_PATH, this.statePath);
        builder.field(Fields.DATA_PATH, this.dataPath);
        builder.field(Fields.IS_CUSTOM_DATA_PATH, this.isCustomDataPath);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString ROUTING = new XContentBuilderString("routing");
        static final XContentBuilderString STATE = new XContentBuilderString("state");
        static final XContentBuilderString STATE_PATH = new XContentBuilderString("state_path");
        static final XContentBuilderString DATA_PATH = new XContentBuilderString("data_path");
        static final XContentBuilderString IS_CUSTOM_DATA_PATH = new XContentBuilderString("is_custom_data_path");
        static final XContentBuilderString SHARD_PATH = new XContentBuilderString("shard_path");
        static final XContentBuilderString PRIMARY = new XContentBuilderString("primary");
        static final XContentBuilderString NODE = new XContentBuilderString("node");
        static final XContentBuilderString RELOCATING_NODE = new XContentBuilderString("relocating_node");

        Fields() {
        }
    }
}

