/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ppl.concurrent;

import edu.stanford.ppl.concurrent.Epoch;
import edu.stanford.ppl.concurrent.EpochNode;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public abstract class CopyOnWriteManager<E>
implements Cloneable {
    private static final int MUTATE = 1;
    private static final int MUTATE_AFTER_FREEZE = 2;
    private static final int BULK_READ = 3;
    private static final int BULK_READ_AFTER_FREEZE = 4;
    private volatile COWEpoch _active;

    public CopyOnWriteManager(E initialValue, int initialSize) {
        this._active = new COWEpoch(initialValue, null, initialSize);
    }

    protected abstract E freezeAndClone(E var1);

    protected abstract E cloneFrozen(E var1);

    public CopyOnWriteManager<E> clone() {
        CopyOnWriteManager copy;
        try {
            copy = (CopyOnWriteManager)super.clone();
        }
        catch (CloneNotSupportedException xx) {
            throw new Error("unexpected", xx);
        }
        COWEpoch a = this._active;
        Object f = a.getFrozenValue();
        while (f == null) {
            a.freezeRequested = true;
            COWEpoch succ = a.getOrCreateSuccessor(a.mutationAllowed);
            succ.awaitActivated();
            if (a.value != succ.value) {
                f = a.value;
            }
            a = succ;
        }
        copy.createNewEpoch(f, a);
        return copy;
    }

    private void createNewEpoch(E f, COWEpoch a) {
        this._active = new COWEpoch(this.cloneFrozen(f), f, a.initialSize);
    }

    public E read() {
        return this._active.value;
    }

    public Epoch.Ticket beginMutation() {
        return this.begin(true);
    }

    public Epoch.Ticket beginQuiescent() {
        return this.begin(false);
    }

    private Epoch.Ticket begin(boolean mutation) {
        EpochNode ticket;
        COWEpoch active = this._active;
        if (active.mutationAllowed == mutation && (ticket = active.attemptArrive()) != null) {
            return ticket;
        }
        return this.begin(mutation, active);
    }

    private Epoch.Ticket begin(boolean mutation, COWEpoch epoch) {
        while (true) {
            EpochNode ticket;
            COWEpoch succ;
            if ((succ = epoch.successorRef.get()) == null) {
                COWEpoch newEpoch = new COWEpoch(mutation);
                EpochNode newTicket = newEpoch.attemptArrive();
                if (epoch.attemptInstallSuccessor(newEpoch)) {
                    newEpoch.awaitActivated();
                    return newTicket;
                }
                succ = epoch.successorRef.get();
            }
            if (succ.mutationAllowed == mutation && (ticket = succ.attemptArrive()) != null) {
                succ.awaitActivated();
                return ticket;
            }
            epoch = succ;
        }
    }

    public E mutable() {
        return this._active.value;
    }

    public E frozen() {
        COWEpoch a = this._active;
        Object f = a.getFrozenValue();
        while (f == null) {
            a.freezeRequested = true;
            COWEpoch succ = a.getOrCreateSuccessor(a.mutationAllowed);
            succ.awaitActivated();
            if (a.value != succ.value) {
                f = a.value;
            }
            a = succ;
        }
        return f;
    }

    public E availableFrozen() {
        return this._active.getFrozenValue();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        COWEpoch a = this._active;
        Integer delta = a.attemptDataSum();
        if (delta != null) {
            return a.initialSize + delta;
        }
        COWEpoch succ = a.getOrCreateSuccessor(a.mutationAllowed);
        succ.awaitActivated();
        return succ.initialSize;
    }

    private class COWEpoch
    extends EpochNode {
        private final Latch _activated;
        final boolean mutationAllowed;
        E value;
        int initialSize;
        private volatile E _frozenValue;
        volatile boolean dirty;
        final AtomicReference<COWEpoch> successorRef = new AtomicReference<Object>(null);
        Epoch.Ticket successorTicket;
        boolean freezeRequested;

        private COWEpoch(boolean mutationAllowed) {
            this._activated = new Latch(false);
            this.mutationAllowed = mutationAllowed;
        }

        public COWEpoch(E value, E frozenValue, int initialSize) {
            this._activated = new Latch(true);
            this.mutationAllowed = true;
            this.value = value;
            this.initialSize = initialSize;
            this._frozenValue = frozenValue;
            this.dirty = frozenValue == null;
        }

        EpochNode attemptInitialArrive() {
            return super.attemptArrive();
        }

        @Override
        public EpochNode attemptArrive() {
            EpochNode ticket = super.attemptArrive();
            if (ticket != null && !this.dirty) {
                this.dirty = true;
                this._frozenValue = null;
            }
            return ticket;
        }

        private void setFrozenValue(E v) {
            if (!this.dirty) {
                this._frozenValue = v;
                if (this.dirty) {
                    this._frozenValue = null;
                }
            }
        }

        E getFrozenValue() {
            Object v = this._frozenValue;
            return this.dirty ? null : (Object)v;
        }

        @Override
        protected void onClosed(int dataSum) {
            assert (dataSum == 0 || this.dirty);
            COWEpoch succ = this.successorRef.get();
            if (this.freezeRequested) {
                succ.value = CopyOnWriteManager.this.freezeAndClone(this.value);
                succ.setFrozenValue(this.value);
            } else {
                succ.value = this.value;
                if (this.dirty) {
                    succ.dirty = true;
                } else {
                    succ.setFrozenValue(this._frozenValue);
                }
            }
            succ.initialSize = this.initialSize + dataSum;
            CopyOnWriteManager.this._active = succ;
            this.successorTicket.leave(0);
            succ._activated.releaseShared(1);
        }

        public void awaitActivated() {
            this._activated.acquireShared(1);
        }

        public COWEpoch getOrCreateSuccessor(boolean preferredMutation) {
            COWEpoch existing = this.successorRef.get();
            if (existing != null) {
                return existing;
            }
            COWEpoch repl = new COWEpoch(preferredMutation);
            if (this.attemptInstallSuccessor(repl)) {
                return repl;
            }
            return this.successorRef.get();
        }

        public boolean attemptInstallSuccessor(COWEpoch succ) {
            EpochNode t = succ.attemptInitialArrive();
            if (this.successorRef.compareAndSet(null, succ)) {
                this.successorTicket = t;
                this.beginClose();
                return true;
            }
            return false;
        }
    }

    private class Latch
    extends AbstractQueuedSynchronizer {
        Latch(boolean triggered) {
            this.setState(triggered ? 0 : 1);
        }

        @Override
        public int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        public boolean tryReleaseShared(int releases) {
            return this.compareAndSetState(1, 0);
        }
    }
}

