/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.google.common.base.Preconditions;
import com.netflix.astyanax.model.Equality;
import java.nio.ByteBuffer;

public class SimpleCompositeBuilder {
    private static final int COMPONENT_OVERHEAD = 3;
    private int bufferSize;
    private ByteBuffer bb;
    private boolean hasControl = true;
    private Equality lastEquality = Equality.EQUAL;
    private final Equality finalEquality;

    public SimpleCompositeBuilder(int bufferSize, Equality finalEquality) {
        this.bb = ByteBuffer.allocate(bufferSize);
        this.finalEquality = finalEquality;
    }

    public void add(ByteBuffer cb, Equality control) {
        this.addWithoutControl(cb);
        this.addControl(control);
    }

    public void addWithoutControl(ByteBuffer cb) {
        Preconditions.checkState((this.lastEquality == Equality.EQUAL ? 1 : 0) != 0, (Object)"Cannot extend composite since non equality control already set");
        if (cb == null) {
            cb = ByteBuffer.allocate(0);
        }
        if (cb.limit() + 3 > this.bb.remaining()) {
            int exponent = (int)Math.ceil(Math.log(cb.limit() + 3 + this.bb.limit()) / Math.log(2.0));
            this.bufferSize = (int)Math.pow(2.0, exponent);
            ByteBuffer temp = ByteBuffer.allocate(this.bufferSize);
            this.bb.flip();
            temp.put(this.bb);
            this.bb = temp;
        }
        if (!this.hasControl) {
            this.addControl(Equality.EQUAL);
        } else if (this.bb.position() > 0) {
            this.bb.position(this.bb.position() - 1);
            this.bb.put(Equality.EQUAL.toByte());
        }
        this.bb.putShort((short)cb.remaining());
        this.bb.put(cb.slice());
        this.hasControl = false;
    }

    public void addControl(Equality control) {
        Preconditions.checkState((!this.hasControl ? 1 : 0) != 0, (Object)"Control byte already set");
        Preconditions.checkState((this.lastEquality == Equality.EQUAL ? 1 : 0) != 0, (Object)"Cannot extend composite since non equality control already set");
        this.hasControl = true;
        this.bb.put(control.toByte());
    }

    public boolean hasControl() {
        return this.hasControl;
    }

    public ByteBuffer get() {
        if (!this.hasControl) {
            this.addControl(this.finalEquality);
        }
        ByteBuffer ret = this.bb.duplicate();
        ret.flip();
        return ret;
    }
}

