/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.google.common.collect.Sets;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.entitystore.AbstractColumnMapper;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.serializers.SerializerTypeInferer;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Iterator;
import java.util.Set;

public class SetColumnMapper
extends AbstractColumnMapper {
    private final Class<?> clazz;
    private final Serializer<?> serializer;

    public SetColumnMapper(Field field) {
        super(field);
        ParameterizedType stringListType = (ParameterizedType)field.getGenericType();
        this.clazz = (Class)stringListType.getActualTypeArguments()[0];
        this.serializer = SerializerTypeInferer.getSerializer(this.clazz);
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public boolean fillMutationBatch(Object entity, ColumnListMutation<String> clm, String prefix) throws Exception {
        Set set = (Set)this.field.get(entity);
        if (set == null) {
            if (this.columnAnnotation.nullable()) {
                return false;
            }
            throw new IllegalArgumentException("cannot write non-nullable column with null value: " + this.columnName);
        }
        for (Object entry : set) {
            clm.putEmptyColumn((Object)(prefix + this.columnName + "." + entry.toString()), null);
        }
        return true;
    }

    @Override
    public boolean setField(Object entity, Iterator<String> name, Column<String> column) throws Exception {
        Set set = (Set)this.field.get(entity);
        if (set == null) {
            set = Sets.newHashSet();
            this.field.set(entity, set);
        }
        String value = name.next();
        if (name.hasNext()) {
            return false;
        }
        set.add(this.serializer.fromByteBuffer(this.serializer.fromString(value)));
        return true;
    }

    @Override
    public void validate(Object entity) throws Exception {
    }
}

