/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.TypeCodec;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

abstract class Token
implements Comparable<Token> {
    Token() {
    }

    public static Factory getFactory(String partitionerName) {
        if (partitionerName.endsWith("Murmur3Partitioner")) {
            return M3PToken.FACTORY;
        }
        if (partitionerName.endsWith("RandomPartitioner")) {
            return RPToken.FACTORY;
        }
        if (partitionerName.endsWith("OrderedPartitioner")) {
            return OPPToken.FACTORY;
        }
        return null;
    }

    static class RPToken
    extends Token {
        private final BigInteger value;
        public static final Factory FACTORY = new Factory(){
            private final ThreadLocal<MessageDigest> md5Digests = new ThreadLocal<MessageDigest>(){

                @Override
                protected MessageDigest initialValue() {
                    try {
                        return MessageDigest.getInstance("MD5");
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException("MD5 doesn't seem to be available on this JVM", e);
                    }
                }

                @Override
                public MessageDigest get() {
                    MessageDigest digest = (MessageDigest)super.get();
                    digest.reset();
                    return digest;
                }
            };

            private BigInteger md5(ByteBuffer data) {
                MessageDigest digest = this.md5Digests.get();
                digest.update(data.duplicate());
                return new BigInteger(digest.digest()).abs();
            }

            @Override
            public RPToken fromString(String tokenStr) {
                return new RPToken(new BigInteger(tokenStr));
            }

            @Override
            public RPToken hash(ByteBuffer partitionKey) {
                return new RPToken(this.md5(partitionKey));
            }
        };

        private RPToken(BigInteger value) {
            this.value = value;
        }

        @Override
        public int compareTo(Token other) {
            assert (other instanceof RPToken);
            return this.value.compareTo(((RPToken)other).value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.value.equals(((RPToken)obj).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    static class OPPToken
    extends Token {
        private final ByteBuffer value;
        public static final Factory FACTORY = new Factory(){

            @Override
            public OPPToken fromString(String tokenStr) {
                return new OPPToken(TypeCodec.StringCodec.utf8Instance.serialize(tokenStr));
            }

            @Override
            public OPPToken hash(ByteBuffer partitionKey) {
                return new OPPToken(partitionKey);
            }
        };

        private OPPToken(ByteBuffer value) {
            this.value = value;
        }

        @Override
        public int compareTo(Token other) {
            assert (other instanceof OPPToken);
            return this.value.compareTo(((OPPToken)other).value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.value.equals(((OPPToken)obj).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    static class M3PToken
    extends Token {
        private final long value;
        public static final Factory FACTORY = new Factory(){

            private long getblock(ByteBuffer key, int offset, int index) {
                int i_8 = index << 3;
                int blockOffset = offset + i_8;
                return ((long)key.get(blockOffset + 0) & 0xFFL) + (((long)key.get(blockOffset + 1) & 0xFFL) << 8) + (((long)key.get(blockOffset + 2) & 0xFFL) << 16) + (((long)key.get(blockOffset + 3) & 0xFFL) << 24) + (((long)key.get(blockOffset + 4) & 0xFFL) << 32) + (((long)key.get(blockOffset + 5) & 0xFFL) << 40) + (((long)key.get(blockOffset + 6) & 0xFFL) << 48) + (((long)key.get(blockOffset + 7) & 0xFFL) << 56);
            }

            private long rotl64(long v, int n) {
                return v << n | v >>> 64 - n;
            }

            private long fmix(long k) {
                k ^= k >>> 33;
                k *= -49064778989728563L;
                k ^= k >>> 33;
                k *= -4265267296055464877L;
                k ^= k >>> 33;
                return k;
            }

            private long murmur(ByteBuffer data) {
                int offset = data.position();
                int length = data.remaining();
                int nblocks = length >> 4;
                long h1 = 0L;
                long h2 = 0L;
                long c1 = -8663945395140668459L;
                long c2 = 5545529020109919103L;
                for (int i = 0; i < nblocks; ++i) {
                    long k1 = this.getblock(data, offset, i * 2 + 0);
                    long k2 = this.getblock(data, offset, i * 2 + 1);
                    k1 *= c1;
                    k1 = this.rotl64(k1, 31);
                    h1 ^= (k1 *= c2);
                    h1 = this.rotl64(h1, 27);
                    h1 += h2;
                    h1 = h1 * 5L + 1390208809L;
                    k2 *= c2;
                    k2 = this.rotl64(k2, 33);
                    h2 ^= (k2 *= c1);
                    h2 = this.rotl64(h2, 31);
                    h2 += h1;
                    h2 = h2 * 5L + 944331445L;
                }
                offset += nblocks * 16;
                long k1 = 0L;
                long k2 = 0L;
                switch (length & 0xF) {
                    case 15: {
                        k2 ^= (long)data.get(offset + 14) << 48;
                    }
                    case 14: {
                        k2 ^= (long)data.get(offset + 13) << 40;
                    }
                    case 13: {
                        k2 ^= (long)data.get(offset + 12) << 32;
                    }
                    case 12: {
                        k2 ^= (long)data.get(offset + 11) << 24;
                    }
                    case 11: {
                        k2 ^= (long)data.get(offset + 10) << 16;
                    }
                    case 10: {
                        k2 ^= (long)data.get(offset + 9) << 8;
                    }
                    case 9: {
                        k2 ^= (long)data.get(offset + 8) << 0;
                        k2 *= c2;
                        k2 = this.rotl64(k2, 33);
                        h2 ^= (k2 *= c1);
                    }
                    case 8: {
                        k1 ^= (long)data.get(offset + 7) << 56;
                    }
                    case 7: {
                        k1 ^= (long)data.get(offset + 6) << 48;
                    }
                    case 6: {
                        k1 ^= (long)data.get(offset + 5) << 40;
                    }
                    case 5: {
                        k1 ^= (long)data.get(offset + 4) << 32;
                    }
                    case 4: {
                        k1 ^= (long)data.get(offset + 3) << 24;
                    }
                    case 3: {
                        k1 ^= (long)data.get(offset + 2) << 16;
                    }
                    case 2: {
                        k1 ^= (long)data.get(offset + 1) << 8;
                    }
                    case 1: {
                        k1 ^= (long)data.get(offset);
                        k1 *= c1;
                        k1 = this.rotl64(k1, 31);
                        h1 ^= (k1 *= c2);
                    }
                }
                h1 ^= (long)length;
                h1 += (h2 ^= (long)length);
                h2 += h1;
                h1 = this.fmix(h1);
                h2 = this.fmix(h2);
                h1 += h2;
                h2 += h1;
                return h1;
            }

            @Override
            public M3PToken fromString(String tokenStr) {
                return new M3PToken(Long.parseLong(tokenStr));
            }

            @Override
            public M3PToken hash(ByteBuffer partitionKey) {
                long v = this.murmur(partitionKey);
                return new M3PToken(v == Long.MIN_VALUE ? Long.MAX_VALUE : v);
            }
        };

        private M3PToken(long value) {
            this.value = value;
        }

        @Override
        public int compareTo(Token other) {
            assert (other instanceof M3PToken);
            long otherValue = ((M3PToken)other).value;
            return this.value < otherValue ? -1 : (this.value == otherValue ? 0 : 1);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.value == ((M3PToken)obj).value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    public static interface Factory {
        public Token fromString(String var1);

        public Token hash(ByteBuffer var1);
    }
}

