/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.storage;

import com.netflix.astyanax.recipes.storage.ChunkedStorageProvider;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDeleter
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectDeleter.class);
    private final ChunkedStorageProvider provider;
    private final String objectName;
    private Integer chunkCount = null;

    public ObjectDeleter(ChunkedStorageProvider provider, String objectName) {
        this.provider = provider;
        this.objectName = objectName;
    }

    public ObjectDeleter withChunkCountToDelete(int count) {
        this.chunkCount = count;
        return this;
    }

    @Override
    public Void call() throws Exception {
        LOG.info("Deleting " + this.objectName);
        this.provider.deleteObject(this.objectName, this.chunkCount);
        return null;
    }
}

