/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.locks;

import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.recipes.locks.LockColumnStrategy;
import com.netflix.astyanax.util.RangeBuilder;

public class StringRowLockColumnStrategy
implements LockColumnStrategy<String> {
    public static final String DEFAULT_LOCK_PREFIX = "_LOCK_";
    private String lockId = null;
    private String prefix = "_LOCK_";

    public String getLockId() {
        return this.lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public StringRowLockColumnStrategy withLockId(String lockId) {
        this.lockId = lockId;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public StringRowLockColumnStrategy withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isLockColumn(String c) {
        return c.startsWith(this.prefix);
    }

    @Override
    public ByteBufferRange getLockColumnRange() {
        return new RangeBuilder().setStart(this.prefix + "\u0000").setEnd(this.prefix + "\uffff").build();
    }

    @Override
    public String generateLockColumn() {
        return this.prefix + this.lockId;
    }
}

