/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.writes;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedStatements {
    private static final Logger LOG = LoggerFactory.getLogger(BatchedStatements.class);
    private List<String> batchQueries = new ArrayList<String>();
    private List<Object> batchValues = new ArrayList<Object>();

    public List<String> getBatchQueries() {
        return this.batchQueries;
    }

    public List<Object> getBatchValues() {
        return this.batchValues;
    }

    public void addBatchQuery(String query) {
        this.batchQueries.add(query);
    }

    public void addBatchValues(List<Object> values) {
        this.batchValues.addAll(values);
    }

    public void addBatchValues(Object ... values) {
        for (Object value : values) {
            this.batchValues.add(value);
        }
    }

    public void addBatch(String query, Object ... values) {
        this.batchQueries.add(query);
        for (Object value : values) {
            this.batchValues.add(value);
        }
    }

    public void addBatch(String query, List<Object> values) {
        this.batchQueries.add(query);
        this.batchValues.addAll(values);
    }

    public void addBatch(BatchedStatements otherBatch) {
        this.batchQueries.addAll(otherBatch.getBatchQueries());
        this.batchValues.addAll(otherBatch.getBatchValues());
    }

    public BoundStatement getBoundStatement(Session session, boolean atomicBatch) {
        String query = this.getBatchQuery(atomicBatch);
        PreparedStatement statement = session.prepare(query);
        BoundStatement boundStatement = new BoundStatement(statement);
        Object[] valueArr = this.batchValues.toArray();
        boundStatement.bind(valueArr);
        return boundStatement;
    }

    public String getBatchQuery(boolean atomicBatch) {
        boolean isBatch;
        StringBuilder sb = new StringBuilder();
        boolean bl = isBatch = this.batchQueries.size() > 1;
        if (isBatch) {
            if (atomicBatch) {
                sb.append("BEGIN BATCH ");
            } else {
                sb.append("BEGIN UNLOGGED BATCH ");
            }
        }
        for (String query : this.batchQueries) {
            sb.append(query);
        }
        if (isBatch) {
            sb.append(" APPLY BATCH; ");
        }
        String query = sb.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Query : " + query);
            LOG.debug("Bind values: " + this.batchValues);
        }
        return query;
    }
}

