/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.reads.model.CqlRowImpl;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.cql.util.CqlTypeMapping;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CqlRowListImpl<K, C>
implements Rows<K, C> {
    private final List<Row<K, C>> rows = new ArrayList<Row<K, C>>();
    private final Map<K, Row<K, C>> lookup;
    private final ColumnFamily<K, C> cf;
    private final CqlColumnFamilyDefinitionImpl cfDef;

    public CqlRowListImpl() {
        this.lookup = new HashMap<K, Row<K, C>>();
        this.cf = null;
        this.cfDef = null;
    }

    public CqlRowListImpl(List<Row<K, C>> newRows) {
        this.rows.addAll(newRows);
        this.lookup = new HashMap<K, Row<K, C>>();
        for (Row<K, C> row : this.rows) {
            this.lookup.put(row.getKey(), row);
        }
        this.cf = null;
        this.cfDef = null;
    }

    public CqlRowListImpl(List<com.datastax.driver.core.Row> resultRows, ColumnFamily<K, C> cf) {
        this.lookup = new HashMap<K, Row<K, C>>();
        this.cf = cf;
        this.cfDef = (CqlColumnFamilyDefinitionImpl)cf.getColumnFamilyDefinition();
        Serializer keySerializer = cf.getKeySerializer();
        Object prevKey = null;
        ArrayList<Object> tempList = new ArrayList<com.datastax.driver.core.Row>();
        for (com.datastax.driver.core.Row row : resultRows) {
            Object rowKey = CqlTypeMapping.getDynamicColumn(row, keySerializer, 0, cf);
            if (prevKey == null || prevKey.equals(rowKey)) {
                tempList.add(row);
            } else {
                this.addToResultRows(tempList);
                tempList = new ArrayList();
                tempList.add(row);
            }
            prevKey = rowKey;
        }
        if (tempList.size() > 0) {
            this.addToResultRows(tempList);
        }
        for (Row row : this.rows) {
            this.lookup.put(row.getKey(), row);
        }
    }

    private void addToResultRows(List<com.datastax.driver.core.Row> rowList) {
        if (this.cfDef.getClusteringKeyColumnDefinitionList().size() == 0 || this.cfDef.getRegularColumnDefinitionList().size() > 1) {
            for (com.datastax.driver.core.Row row : rowList) {
                this.rows.add(new CqlRowImpl<K, C>(row, this.cf));
            }
        } else {
            this.rows.add(new CqlRowImpl<K, C>(rowList, this.cf));
        }
    }

    public Iterator<Row<K, C>> iterator() {
        return this.rows.iterator();
    }

    public Row<K, C> getRow(K key) {
        return this.lookup.get(key);
    }

    public int size() {
        return this.rows.size();
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public Row<K, C> getRowByIndex(int index) {
        return this.rows.get(index);
    }

    public Collection<K> getKeys() {
        return Lists.transform(this.rows, (Function)new Function<Row<K, C>, K>(){

            public K apply(Row<K, C> row) {
                return row.getKey();
            }
        });
    }
}

