/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.cql.CqlAbstractExecutionImpl;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.reads.CqlRowSliceColumnCountQueryImpl;
import com.netflix.astyanax.cql.reads.model.CqlColumnSlice;
import com.netflix.astyanax.cql.reads.model.CqlRangeBuilder;
import com.netflix.astyanax.cql.reads.model.CqlRangeImpl;
import com.netflix.astyanax.cql.reads.model.CqlRowListImpl;
import com.netflix.astyanax.cql.reads.model.CqlRowListIterator;
import com.netflix.astyanax.cql.reads.model.CqlRowSlice;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.cql.util.CFQueryContext;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.ColumnSlice;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.query.RowSliceColumnCountQuery;
import com.netflix.astyanax.query.RowSliceQuery;
import com.netflix.astyanax.serializers.CompositeRangeBuilder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CqlRowSliceQueryImpl<K, C>
implements RowSliceQuery<K, C> {
    private final CqlKeyspaceImpl.KeyspaceContext ksContext;
    private final CFQueryContext<K, C> cfContext;
    private final CqlRowSlice<K> rowSlice;
    private CqlColumnSlice<C> columnSlice = new CqlColumnSlice();
    private CompositeRangeBuilder.CompositeByteBufferRange compositeRange = null;
    private final boolean isPaginating;
    private boolean useCaching = false;
    private final RowSliceQueryType rowQueryType;
    private ColumnSliceQueryType colQueryType = ColumnSliceQueryType.AllColumns;

    public CqlRowSliceQueryImpl(CqlKeyspaceImpl.KeyspaceContext ksCtx, CFQueryContext<K, C> cfCtx, CqlRowSlice<K> rSlice, boolean useCaching) {
        this(ksCtx, cfCtx, rSlice, true, useCaching);
    }

    public CqlRowSliceQueryImpl(CqlKeyspaceImpl.KeyspaceContext ksCtx, CFQueryContext<K, C> cfCtx, CqlRowSlice<K> rSlice, boolean condition, boolean useCaching) {
        this.ksContext = ksCtx;
        this.cfContext = cfCtx;
        this.rowSlice = rSlice;
        this.isPaginating = condition;
        this.rowQueryType = this.rowSlice.isRangeQuery() ? RowSliceQueryType.RowRange : RowSliceQueryType.RowKeys;
        this.useCaching = useCaching;
    }

    public OperationResult<Rows<K, C>> execute() throws ConnectionException {
        return new InternalRowQueryExecutionImpl(this).execute();
    }

    public ListenableFuture<OperationResult<Rows<K, C>>> executeAsync() throws ConnectionException {
        return new InternalRowQueryExecutionImpl(this).executeAsync();
    }

    public RowSliceQuery<K, C> withColumnSlice(C ... columns) {
        this.colQueryType = ColumnSliceQueryType.ColumnSet;
        return this.withColumnSlice((Collection<C>)Arrays.asList(columns));
    }

    public RowSliceQuery<K, C> withColumnSlice(Collection<C> columns) {
        this.colQueryType = ColumnSliceQueryType.ColumnSet;
        this.columnSlice = new CqlColumnSlice<C>(columns);
        return this;
    }

    public RowSliceQuery<K, C> withColumnSlice(ColumnSlice<C> columns) {
        this.colQueryType = ColumnSliceQueryType.ColumnSet;
        this.columnSlice = new CqlColumnSlice<C>(columns);
        return this;
    }

    public RowSliceQuery<K, C> withColumnRange(C startColumn, C endColumn, boolean reversed, int count) {
        this.colQueryType = ColumnSliceQueryType.ColumnRange;
        this.columnSlice = new CqlColumnSlice(new CqlRangeBuilder().setColumn("column1").setStart(startColumn).setEnd(endColumn).setReversed(reversed).setLimit(count).build());
        return this;
    }

    public RowSliceQuery<K, C> withColumnRange(ByteBuffer startColumn, ByteBuffer endColumn, boolean reversed, int limit) {
        this.colQueryType = ColumnSliceQueryType.ColumnRange;
        Serializer colSerializer = this.cfContext.getColumnFamily().getColumnSerializer();
        Object start = startColumn != null && startColumn.capacity() > 0 ? colSerializer.fromByteBuffer(startColumn) : null;
        Object end = endColumn != null && endColumn.capacity() > 0 ? colSerializer.fromByteBuffer(endColumn) : null;
        return this.withColumnRange(start, end, reversed, limit);
    }

    public RowSliceQuery<K, C> withColumnRange(ByteBufferRange range) {
        this.colQueryType = ColumnSliceQueryType.ColumnRange;
        if (range instanceof CompositeRangeBuilder.CompositeByteBufferRange) {
            this.compositeRange = (CompositeRangeBuilder.CompositeByteBufferRange)range;
        } else if (range instanceof CompositeRangeBuilder) {
            this.compositeRange = ((CompositeRangeBuilder)range).build();
        } else if (range instanceof CqlRangeImpl) {
            this.columnSlice.setCqlRange((CqlRangeImpl)range);
        } else {
            return this.withColumnRange(range.getStart(), range.getEnd(), range.isReversed(), range.getLimit());
        }
        return this;
    }

    public RowSliceColumnCountQuery<K> getColumnCounts() {
        Statement query = new InternalRowQueryExecutionImpl(this).getQuery();
        return new CqlRowSliceColumnCountQueryImpl(this.ksContext, this.cfContext, query);
    }

    public CqlRowSlice<K> getRowSlice() {
        return this.rowSlice;
    }

    public CqlColumnSlice<C> getColumnSlice() {
        return this.columnSlice;
    }

    public CompositeRangeBuilder.CompositeByteBufferRange getCompositeRange() {
        return this.compositeRange;
    }

    public ColumnSliceQueryType getColQueryType() {
        return this.colQueryType;
    }

    public RowSliceQueryType getRowQueryType() {
        return this.rowQueryType;
    }

    private class InternalRowQueryExecutionImpl
    extends CqlAbstractExecutionImpl<Rows<K, C>> {
        private final CqlColumnFamilyDefinitionImpl cfDef;
        private final CqlRowSliceQueryImpl<K, C> rowSliceQuery;

        public InternalRowQueryExecutionImpl(CqlRowSliceQueryImpl<K, C> rSliceQuery) {
            super(CqlRowSliceQueryImpl.this.ksContext, CqlRowSliceQueryImpl.this.cfContext);
            this.cfDef = (CqlColumnFamilyDefinitionImpl)this.cf.getColumnFamilyDefinition();
            this.rowSliceQuery = rSliceQuery;
        }

        public InternalRowQueryExecutionImpl(CqlKeyspaceImpl.KeyspaceContext ksContext, CFQueryContext<?, ?> cfContext) {
            super(ksContext, cfContext);
            this.cfDef = (CqlColumnFamilyDefinitionImpl)this.cf.getColumnFamilyDefinition();
            this.rowSliceQuery = null;
        }

        @Override
        public Statement getQuery() {
            return this.cfDef.getRowQueryGenerator().getQueryStatement(this.rowSliceQuery, CqlRowSliceQueryImpl.this.useCaching);
        }

        @Override
        public Rows<K, C> parseResultSet(ResultSet rs) throws NotFoundException {
            if (!CqlRowSliceQueryImpl.this.isPaginating) {
                List rows = rs.all();
                if (rows == null || rows.isEmpty()) {
                    return new CqlRowListImpl();
                }
                return new CqlRowListImpl(rows, this.cf);
            }
            if (rs == null) {
                return new CqlRowListImpl();
            }
            return new CqlRowListIterator(rs, this.cf);
        }

        @Override
        public CassandraOperationType getOperationType() {
            return CassandraOperationType.GET_ROW;
        }
    }

    public static enum ColumnSliceQueryType {
        AllColumns,
        ColumnSet,
        ColumnRange;

    }

    public static enum RowSliceQueryType {
        RowKeys,
        RowRange;

    }
}

