/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.astyanax.ExceptionCallback;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.RowCallback;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.TokenRange;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.CqlOperationResultImpl;
import com.netflix.astyanax.cql.reads.model.CqlColumnSlice;
import com.netflix.astyanax.cql.reads.model.CqlRangeBuilder;
import com.netflix.astyanax.cql.reads.model.CqlRangeImpl;
import com.netflix.astyanax.cql.reads.model.CqlRowListImpl;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnSlice;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.partitioner.Murmur3Partitioner;
import com.netflix.astyanax.partitioner.Partitioner;
import com.netflix.astyanax.query.AllRowsQuery;
import com.netflix.astyanax.query.CheckpointManager;
import com.netflix.astyanax.query.ColumnFamilyQuery;
import com.netflix.astyanax.query.RowSliceQuery;
import com.netflix.astyanax.shallows.EmptyCheckpointManager;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlAllRowsQueryImpl<K, C>
implements AllRowsQuery<K, C> {
    private static final Logger LOG = LoggerFactory.getLogger(CqlAllRowsQueryImpl.class);
    private static final Partitioner DEFAULT_PARTITIONER = Murmur3Partitioner.get();
    private static final int DEFAULT_PAGE_SIZE = 100;
    private final Keyspace keyspace;
    private final ColumnFamily<K, C> columnFamily;
    private Integer rowLimit = 100;
    private Integer concurrencyLevel;
    private ExecutorService executor;
    private CheckpointManager checkpointManager = new EmptyCheckpointManager();
    private RowCallback<K, C> rowCallback;
    private boolean repeatLastToken;
    private ColumnSlice<C> columnSlice;
    private String startToken;
    private String endToken;
    private Boolean includeEmptyRows;
    private List<Future<Boolean>> futures = Lists.newArrayList();
    private AtomicBoolean cancelling = new AtomicBoolean(false);
    private Partitioner partitioner = DEFAULT_PARTITIONER;
    private ConsistencyLevel consistencyLevel;
    private ExceptionCallback exceptionCallback;
    private AtomicReference<Exception> error = new AtomicReference();

    public CqlAllRowsQueryImpl(Keyspace ks, ColumnFamily<K, C> cf) {
        this.keyspace = ks;
        this.columnFamily = cf;
    }

    public AllRowsQuery<K, C> setBlockSize(int blockSize) {
        this.setRowLimit(blockSize);
        return this;
    }

    public AllRowsQuery<K, C> setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
        return this;
    }

    public AllRowsQuery<K, C> setExceptionCallback(ExceptionCallback cb) {
        this.exceptionCallback = cb;
        return this;
    }

    public AllRowsQuery<K, C> setCheckpointManager(CheckpointManager manager) {
        this.checkpointManager = manager;
        return this;
    }

    public AllRowsQuery<K, C> setRepeatLastToken(boolean condition) {
        this.repeatLastToken = condition;
        return this;
    }

    public AllRowsQuery<K, C> setIncludeEmptyRows(boolean flag) {
        this.includeEmptyRows = flag;
        return this;
    }

    public AllRowsQuery<K, C> withColumnSlice(C ... columns) {
        return this.withColumnSlice((Collection<C>)Arrays.asList(columns));
    }

    public AllRowsQuery<K, C> withColumnSlice(Collection<C> columns) {
        this.columnSlice = new CqlColumnSlice<C>(columns);
        return this;
    }

    public AllRowsQuery<K, C> withColumnSlice(ColumnSlice<C> columns) {
        this.columnSlice = new CqlColumnSlice<C>(columns);
        return this;
    }

    public AllRowsQuery<K, C> withColumnRange(C startColumn, C endColumn, boolean reversed, int count) {
        CqlColumnFamilyDefinitionImpl cfDef = (CqlColumnFamilyDefinitionImpl)this.columnFamily.getColumnFamilyDefinition();
        String pkColName = cfDef.getPartitionKeyColumnDefinitionList().get(1).getName();
        this.columnSlice = new CqlColumnSlice(new CqlRangeBuilder().setColumn(pkColName).setStart(startColumn).setEnd(endColumn).setReversed(reversed).setLimit(count).build());
        return this;
    }

    public AllRowsQuery<K, C> withColumnRange(ByteBuffer startColumn, ByteBuffer endColumn, boolean reversed, int limit) {
        Serializer colSerializer = this.columnFamily.getColumnSerializer();
        Object start = startColumn != null && startColumn.capacity() > 0 ? colSerializer.fromByteBuffer(startColumn) : null;
        Object end = endColumn != null && endColumn.capacity() > 0 ? colSerializer.fromByteBuffer(endColumn) : null;
        return this.withColumnRange(start, end, reversed, limit);
    }

    public AllRowsQuery<K, C> withColumnRange(ByteBufferRange range) {
        if (range instanceof CqlRangeImpl) {
            this.columnSlice = new CqlColumnSlice();
            ((CqlColumnSlice)this.columnSlice).setCqlRange((CqlRangeImpl)range);
            return this;
        }
        return this.withColumnRange(range.getStart(), range.getEnd(), range.isReversed(), range.getLimit());
    }

    public AllRowsQuery<K, C> setConcurrencyLevel(int numberOfThreads) {
        this.concurrencyLevel = numberOfThreads;
        return this;
    }

    @Deprecated
    public AllRowsQuery<K, C> setThreadCount(int numberOfThreads) {
        this.concurrencyLevel = numberOfThreads;
        return this;
    }

    public void executeWithCallback(RowCallback<K, C> callback) throws ConnectionException {
        this.rowCallback = callback;
        this.executeTasks();
    }

    public AllRowsQuery<K, C> forTokenRange(BigInteger start, BigInteger end) {
        return this.forTokenRange(start.toString(), end.toString());
    }

    public AllRowsQuery<K, C> forTokenRange(String start, String end) {
        this.startToken = start;
        this.endToken = end;
        return this;
    }

    public OperationResult<Rows<K, C>> execute() throws ConnectionException {
        final AtomicReference<Object> reference = new AtomicReference<Object>(null);
        final List list = Collections.synchronizedList(new LinkedList());
        RowCallback rowCallback = new RowCallback<K, C>(){

            public void success(Rows<K, C> rows) {
                if (rows != null && !rows.isEmpty()) {
                    for (Row row : rows) {
                        list.add(row);
                    }
                }
            }

            public boolean failure(ConnectionException e) {
                reference.set(e);
                return false;
            }
        };
        this.executeWithCallback(rowCallback);
        if (reference.get() != null) {
            throw (ConnectionException)reference.get();
        }
        CqlRowListImpl allRows = new CqlRowListImpl(list);
        return new CqlOperationResultImpl<Rows<K, C>>(null, allRows);
    }

    public ListenableFuture<OperationResult<Rows<K, C>>> executeAsync() throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Boolean executeTasks() throws ConnectionException {
        this.error.set(null);
        ArrayList subtasks = Lists.newArrayList();
        if (this.concurrencyLevel != null || this.startToken != null || this.endToken != null) {
            List tokens = this.partitioner.splitTokenRange(this.startToken == null ? this.partitioner.getMinToken() : this.startToken, this.endToken == null ? this.partitioner.getMinToken() : this.endToken, this.concurrencyLevel == null ? 1 : this.concurrencyLevel);
            for (TokenRange range : tokens) {
                subtasks.add(this.makeTokenRangeTask(range.getStartToken(), range.getEndToken()));
            }
        } else {
            List ranges = this.keyspace.describeRing(null, null);
            for (TokenRange range : ranges) {
                if (range.getStartToken().equals(range.getEndToken())) {
                    subtasks.add(this.makeTokenRangeTask(range.getStartToken(), range.getEndToken()));
                    continue;
                }
                subtasks.add(this.makeTokenRangeTask(this.partitioner.getTokenMinusOne(range.getStartToken()), range.getEndToken()));
            }
        }
        try {
            if (this.executor != null) {
                this.futures.addAll(this.startTasks(this.executor, subtasks));
                return this.waitForTasksToFinish();
            }
            ExecutorService localExecutor = Executors.newFixedThreadPool(subtasks.size(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("AstyanaxAllRowsQuery-%d").build());
            try {
                this.futures.addAll(this.startTasks(localExecutor, subtasks));
                Boolean bl = this.waitForTasksToFinish();
                return bl;
            }
            finally {
                localExecutor.shutdownNow();
            }
        }
        catch (Exception e) {
            this.error.compareAndSet(null, e);
            LOG.warn("AllRowsReader terminated. " + e.getMessage(), (Throwable)e);
            this.cancel();
            throw new RuntimeException(this.error.get());
        }
    }

    private Callable<Boolean> makeTokenRangeTask(final String startToken, final String endToken) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    String currentToken;
                    try {
                        currentToken = CqlAllRowsQueryImpl.this.checkpointManager.getCheckpoint(startToken);
                        if (currentToken == null) {
                            currentToken = startToken;
                        } else if (currentToken.equals(endToken)) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        CqlAllRowsQueryImpl.this.error.compareAndSet(null, e);
                        LOG.error("Failed to get checkpoint for startToken " + startToken, (Throwable)e);
                        CqlAllRowsQueryImpl.this.cancel();
                        throw new RuntimeException("Failed to get checkpoint for startToken " + startToken, e);
                    }
                    int localPageSize = CqlAllRowsQueryImpl.this.rowLimit;
                    int rowsToSkip = 0;
                    while (!CqlAllRowsQueryImpl.this.cancelling.get()) {
                        Rows rows;
                        RowSliceQuery query = CqlAllRowsQueryImpl.this.prepareQuery().getKeyRange(null, null, currentToken, endToken, -1);
                        if (CqlAllRowsQueryImpl.this.columnSlice != null) {
                            query.withColumnSlice(CqlAllRowsQueryImpl.this.columnSlice);
                        }
                        if (!(rows = (Rows)query.execute().getResult()).isEmpty()) {
                            block18: {
                                try {
                                    if (CqlAllRowsQueryImpl.this.rowCallback != null) {
                                        try {
                                            CqlAllRowsQueryImpl.this.rowCallback.success(rows);
                                            break block18;
                                        }
                                        catch (Exception e) {
                                            LOG.error("Failed to process rows", (Throwable)e);
                                            CqlAllRowsQueryImpl.this.cancel();
                                            return false;
                                        }
                                    }
                                    LOG.error("Row function is empty");
                                }
                                catch (Exception e) {
                                    CqlAllRowsQueryImpl.this.error.compareAndSet(null, e);
                                    LOG.warn(e.getMessage(), (Throwable)e);
                                    CqlAllRowsQueryImpl.this.cancel();
                                    throw new RuntimeException("Error processing row", e);
                                }
                            }
                            if (rows.size() == CqlAllRowsQueryImpl.this.rowLimit.intValue()) {
                                Row lastRow = rows.getRowByIndex(rows.size() - 1);
                                String lastToken = CqlAllRowsQueryImpl.this.partitioner.getTokenForKey(lastRow.getRawKey());
                                CqlAllRowsQueryImpl.this.checkpointManager.trackCheckpoint(startToken, currentToken);
                                if (CqlAllRowsQueryImpl.this.repeatLastToken) {
                                    currentToken = CqlAllRowsQueryImpl.this.partitioner.getTokenMinusOne(lastToken);
                                    rowsToSkip = 1;
                                    int i = rows.size() - 2;
                                    while (i >= 0 && lastToken.equals(CqlAllRowsQueryImpl.this.partitioner.getTokenForKey(rows.getRowByIndex(i).getRawKey()))) {
                                        --i;
                                        ++rowsToSkip;
                                    }
                                    if (rowsToSkip != localPageSize) continue;
                                    ++localPageSize;
                                    continue;
                                }
                                currentToken = lastToken;
                                continue;
                            }
                        }
                        CqlAllRowsQueryImpl.this.checkpointManager.trackCheckpoint(startToken, endToken);
                        return true;
                    }
                    CqlAllRowsQueryImpl.this.cancel();
                    return false;
                }
                catch (Exception e) {
                    CqlAllRowsQueryImpl.this.error.compareAndSet(null, e);
                    LOG.error("Error process token/key range", (Throwable)e);
                    CqlAllRowsQueryImpl.this.cancel();
                    throw new RuntimeException("Error process token/key range", e);
                }
            }
        };
    }

    private List<Future<Boolean>> startTasks(ExecutorService executor, List<Callable<Boolean>> callables) {
        ArrayList tasks = Lists.newArrayList();
        for (Callable<Boolean> callable : callables) {
            tasks.add(executor.submit(callable));
        }
        return tasks;
    }

    private boolean waitForTasksToFinish() throws Exception {
        for (Future<Boolean> future : this.futures) {
            try {
                if (future.get().booleanValue()) continue;
                this.cancel();
                return false;
            }
            catch (Exception e) {
                this.error.compareAndSet(null, e);
                this.cancel();
                throw e;
            }
        }
        return true;
    }

    private ColumnFamilyQuery<K, C> prepareQuery() {
        ColumnFamilyQuery query = this.keyspace.prepareQuery(this.columnFamily);
        if (this.consistencyLevel != null) {
            query.setConsistencyLevel(this.consistencyLevel);
        }
        return query;
    }

    public synchronized void cancel() {
        this.cancelling.compareAndSet(false, true);
    }
}

